<?php
/*
 *
 * Sends a letter to site owner with the data of the chosen theme
 * and information about the customer
 *
 */


// Options
//-------------------------------------------------------
$email = 'test@gmail.com';													// Site owner's email
$secret_key = '6Lf05DIUAAAAAAyuDGxIy9_mteWvbD-_z2QPJhYc';					// Secret key from Google reCAPTCHA 2
$url_to_google_api = "https://www.google.com/recaptcha/api/siteverify";		// URL to verify captcha


// Send a letter
//-------------------------------------------------------
$recaptcha = widget_themes_get_value_gp('g-recaptcha-response');
if (!empty($recaptcha)) {
	$query = $url_to_google_api . '?secret=' . $secret_key . '&response=' . $recaptcha . '&remoteip=' . $_SERVER['REMOTE_ADDR'];
	$respond = array('error'=>'');
	try {
    	$data = json_decode(file_get_contents($query));
    } catch (Exception $e) {
    	$respond['error'] = 'Error while check Google reCAPTCHA';
    }
	if ($data->success) {
		$theme_id 	= widget_themes_get_value_gp('theme_id');
		$theme_name	= widget_themes_get_value_gp('theme_name');
		$user_name	= widget_themes_get_value_gp('name');
		$user_email	= widget_themes_get_value_gp('email');
		$user_phone	= widget_themes_get_value_gp('phone');
		$user_msg	= widget_themes_get_value_gp('message');
		$subj = sprintf('Order theme "%s" (ID: %d) from "%s"', $theme_name, $theme_id, $user_name);
		$msg = "\nTheme details:"
			.  "\n-----------------"
			.  "\nID: {$theme_id}" 
			.  "\nName: {$theme_name}"
			.  "\n\n"
			.  "\nCustomer details:"
			.  "\n-----------------"
			.  "\nName: {$user_name}"
			.  "\nE-mail: {$user_email}"
            .  "\nPhone: {$user_phone}"
			.  "\n\n"
            .  "\nMessage:"
			.  "\n-----------------"
            .  "\n{$user_msg}";
		if (!@mail($email, $subj, $msg)) {
			$respond['error'] = 'Error send message!';
		}
    } else {
    	$respond['error'] = 'Sorry, but I think that you are robot!';
    }
} else {
   	$respond['error'] = 'Please, fill the field with CAPTCHA!';
}
echo json_encode($respond);



// Utilities
//-------------------------------------------------------


// Strip slashes if Magic Quotes is on
function widget_themes_stripslashes($val) {
	static $magic = 0;
	if ($magic === 0) {
		$magic = version_compare(phpversion(), '5.4', '>=')
				|| (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()==1) 
				|| (function_exists('get_magic_quotes_runtime') && get_magic_quotes_runtime()==1); 
				// || strtolower(ini_get('magic_quotes_sybase'))=='on';
	}
	if (is_array($val)) {
		foreach($val as $k=>$v)
			$val[$k] = widget_themes_stripslashes($v);
	} else
		$val = $magic ? stripslashes(trim($val)) : trim($val);
	return $val;
}

// Get GET, POST value
function widget_themes_get_value_gp($name, $defa='') {
	if (isset($_GET[$name]))		$rez = widget_themes_stripslashes($_GET[$name]);
	else if (isset($_POST[$name]))	$rez = widget_themes_stripslashes($_POST[$name]);
	else							$rez = $defa;
	return $rez;
}
