<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.22
 */

if (!defined("MILITAROLOGY_THEME_FREE")) define("MILITAROLOGY_THEME_FREE", false);
if (!defined("MILITAROLOGY_THEME_FREE_WP")) define("MILITAROLOGY_THEME_FREE_WP", false);

// Theme storage
$MILITAROLOGY_STORAGE = array(
	// Theme required plugin's slugs
	'required_plugins' => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'					=> esc_html__('ThemeREX Addons', 'militarology'),

			// Recommended (supported) plugins fot both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'contact-form-7'				=> esc_html__('Contact Form 7', 'militarology'),
      		'date-time-picker-field'        => esc_html__('Date Time Picker Field', 'militarology'),
      		'give'        					=> esc_html__('Give - Donation Plugin', 'militarology'),
			'wp-gdpr-compliance'            => esc_html__('WP GDPR Compliance', 'militarology'),
		),

		// List of plugins for PREMIUM version only
		//-----------------------------------------------------
		MILITAROLOGY_THEME_FREE 
			? array(
					// Recommended (supported) plugins for the FREE (lite) version
					'siteorigin-panels'			=> esc_html__('SiteOrigin Panels', 'militarology'),
					) 
			: array(
					// Recommended (supported) plugins for the PRO (full) version
					// If plugin not need - comment (or remove) it
					'essential-grid'			=> esc_html__('Essential Grid', 'militarology'),
					'trx_updater'				=> esc_html__('ThemeREX Updater', 'militarology'),
					'revslider'					=> esc_html__('Revolution Slider', 'militarology'),
					'js_composer'				=> esc_html__('WPBakery Page Builder', 'militarology')
				)
	),
	
	// Theme-specific URLs (will be escaped in place of the output)
    'theme_pro_key'     => 'env-ancora',
	'theme_demo_url'	=> 'http://militarology.ancorathemes.com',
	'theme_doc_url'		=> 'http://militarology.ancorathemes.com/doc',
	'theme_download_url'=> 'https://themeforest.net/item/militarology-military-service-wordpress-theme/21308332',

	'theme_support_url'	=> 'https://themerex.net/support/',								// Ancora

	'theme_video_url'	=> 'https://www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',	// Ancora
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( !function_exists('militarology_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'militarology_customizer_theme_setup1', 1 );
	function militarology_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		militarology_storage_set('settings', array(
			
			'duplicate_options'		=> 'child',		// none  - use separate options for template and child-theme
													// child - duplicate theme options from the main theme to the child-theme only
													// both  - sinchronize changes in the theme options between main and child themes
			
			'custmize_refresh'		=> 'auto',		// Refresh method for preview area in the Appearance - Customize:
													// auto - refresh preview area on change each field with Theme Options
													// manual - refresh only obn press button 'Refresh' at the top of Customize frame
		
			'max_load_fonts'		=> 5,			// Max fonts number to load from Google fonts or from uploaded fonts
		
			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true,		// Place 'comment' field before the 'name' and 'email'
			
			'socials_type'			=> 'icons',		// Type of socials:
													// icons - use font icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_type'			=> 'icons',		// Type of other icons:
													// icons - use font icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_selector'		=> 'internal',	// Icons selector in the shortcodes:
													// vc default - standard VC icons selector (very slow and don't support images)
													// internal - internal popup with plugin's or theme's icons list (fast)
			'check_min_version'		=> true,		// Check if exists a .min version of .css and .js and return path to it
													// instead the path to the original file
													// (if debug_mode is off and modification time of the original file < time of the .min file)
			'autoselect_menu'		=> false,		// Show any menu if no menu selected in the location 'main_menu'
													// (for example, the theme is just activated)
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
			
			'tgmpa_upload'			=> false		// Allow upload not pre-packaged plugins via TGMPA
		));


		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		militarology_storage_set('load_fonts', array(
			// Font-face packed with theme
			array(
				'name'   => 'Rajdhani',
				'family' => 'sans-serif'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		militarology_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		militarology_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'militarology'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '26px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.4em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '2.667em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '5.3rem',
				'margin-bottom'		=> '3rem'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '2em',
                'font-weight'		=> '700',
                'font-style'		=> 'normal',
                'line-height'		=> '1.06em',
                'text-decoration'	=> 'none',
                'text-transform'	=> 'uppercase',
                'letter-spacing'	=> '0px',
                'margin-top'		=> '5.3rem',
                'margin-bottom'		=> '2.8rem'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '1.667em',
                'font-weight'		=> '700',
                'font-style'		=> 'normal',
                'line-height'		=> '1.1em',
                'text-decoration'	=> 'none',
                'text-transform'	=> 'uppercase',
                'letter-spacing'	=> '0px',
                'margin-top'		=> '5.4rem',
                'margin-bottom'		=> '2.2rem'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '1.333em',
                'font-weight'		=> '700',
                'font-style'		=> 'normal',
                'line-height'		=> '1.08em',
                'text-decoration'	=> 'none',
                'text-transform'	=> 'uppercase',
                'letter-spacing'	=> '0px',
                'margin-top'		=> '4.1rem',
                'margin-bottom'		=> '2rem'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '18px',
                'font-weight'		=> '700',
                'font-style'		=> 'normal',
                'line-height'		=> '1.22em',
                'text-decoration'	=> 'none',
                'text-transform'	=> 'uppercase',
                'letter-spacing'	=> '0px',
                'margin-top'		=> '3.9rem',
                'margin-bottom'		=> '1.5rem'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '15px',
                'font-weight'		=> '700',
                'font-style'		=> 'normal',
                'line-height'		=> '1.2em',
                'text-decoration'	=> 'none',
                'text-transform'	=> 'uppercase',
                'letter-spacing'	=> '1.4px',
                'margin-top'		=> '3.3rem',
                'margin-bottom'		=> '1.1rem'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'militarology'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '1.11em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1.4px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'militarology'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',	// Attention! Firefox don't allow line-height less then 1.5em in the select
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'militarology'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1.4px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'militarology'),
				'description'		=> esc_html__('Font settings of the main menu items', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1.4px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'militarology'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'militarology'),
				'font-family'		=> '"Rajdhani",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1.4px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		militarology_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'militarology'),
							'description'	=> esc_html__('Colors of the main content area', 'militarology')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'militarology'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'militarology')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'militarology'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'militarology')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'militarology'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'militarology')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'militarology'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'militarology')
							),
			)
		);
		militarology_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'militarology'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'militarology')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'militarology'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'militarology')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'militarology'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'militarology')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'militarology'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'militarology')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'militarology'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'militarology')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'militarology'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'militarology')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'militarology'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'militarology')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'militarology'),
							'description'	=> esc_html__('Color of the links inside this block', 'militarology')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'militarology'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'militarology')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'militarology'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'militarology')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'militarology'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'militarology')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'militarology'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'militarology')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'militarology'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'militarology')
							)
			)
		);
		militarology_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'militarology'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',  
					'bd_color'			=> '#f0eff0',   
		
					// Text and links colors
					'text'				=> '#7c7b7b',   
					'text_light'		=> '#a7a7a7',   
					'text_dark'			=> '#1b181a',   
					'text_link'			=> '#ec3f3a',   
					'text_hover'		=> '#1b181a',   
					'text_link2'		=> '#ef3d32',   
					'text_hover2'		=> '#0d0d0d',   
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#f6f6f6',   
					'alter_bg_hover'	=> '#f0f0f0',   
					'alter_bd_color'	=> '#dadada',   
					'alter_bd_hover'	=> '#dadada',
					'alter_text'		=> '#333333',
					'alter_light'		=> '#afaeae',   
					'alter_dark'		=> '#1d1d1d',
					'alter_link'		=> '#fe7259',
					'alter_hover'		=> '#72cfd5',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#434445',   
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#494648',   
					'extra_bd_hover'	=> '#2f2e2f',   
					'extra_text'		=> '#939293',   
					'extra_light'		=> '#e5dfdb',   
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#72cfd5',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#ffffff',   
					'input_bg_hover'	=> '#ffffff',   
					'input_bd_color'	=> '#cbcacb',   
					'input_bd_hover'	=> '#1b181a',   
					'input_text'		=> '#7c7b7b',   
					'input_light'		=> '#7c7b7b',   
					'input_dark'		=> '#7c7b7b',   
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#ffffff',   
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#1b181a',   
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'militarology'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#0e0d12',
					'bd_color'			=> '#2e2c33',
		
					// Text and links colors
					'text'				=> '#939293',   
					'text_light'		=> '#5f5f5f',
					'text_dark'			=> '#ffffff',
                    'text_link'			=> '#ec3f3a',   
                    'text_hover'		=> '#1b181a',   
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#1e1d22',
					'alter_bg_hover'	=> '#333333',
					'alter_bd_color'	=> '#464646',
					'alter_bd_hover'	=> '#4a4a4a',
					'alter_text'		=> '#a6a6a6',
					'alter_light'		=> '#5d5d5d',   
					'alter_dark'		=> '#fad2d0',   
					'alter_link'		=> '#ec3f3a',
					'alter_hover'		=> '#fe7259',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#434445',   
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#464646',
					'extra_bd_hover'	=> '#4a4a4a',
					'extra_text'		=> '#939293',   
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#ec3f3a',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> 'rgba(255,255,255,0)',   
					'input_bg_hover'	=> 'rgba(255,255,255,0)',   
					'input_bd_color'	=> '#cbcacb',   
					'input_bd_hover'	=> '#ffffff',   
					'input_text'		=> '#7c7b7b',   
					'input_light'		=> '#ffffff',   
					'input_dark'		=> '#ffffff',   
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1b181a',   
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#1b181a',  
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
		
		// Simple schemes substitution
		militarology_storage_set('schemes_simple', array(
			// Main color	// Slave elements and it's darkness koef.
			'text_link'		=> array('alter_hover' => 1,	'extra_link' => 1, 'inverse_bd_color' => 0.85, 'inverse_bd_hover' => 0.7),
			'text_hover'	=> array('alter_link' => 1,		'extra_hover' => 1),
			'text_link2'	=> array('alter_hover2' => 1,	'extra_link2' => 1),
			'text_hover2'	=> array('alter_link2' => 1,	'extra_hover2' => 1),
			'text_link3'	=> array('alter_hover3' => 1,	'extra_link3' => 1),
			'text_hover3'	=> array('alter_link3' => 1,	'extra_hover3' => 1)
		));

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		militarology_storage_set('scheme_colors_add', array(
			'bg_color_0'		=> array('color' => 'bg_color',			'alpha' => 0),
			'bg_color_02'		=> array('color' => 'bg_color',			'alpha' => 0.2),
			'bg_color_07'		=> array('color' => 'bg_color',			'alpha' => 0.7),
			'bg_color_08'		=> array('color' => 'bg_color',			'alpha' => 0.8),
			'bg_color_09'		=> array('color' => 'bg_color',			'alpha' =>  0.9),
			'alter_bg_color_07'	=> array('color' => 'alter_bg_color',	'alpha' => 0.7),
			'alter_bg_color_04'	=> array('color' => 'alter_bg_color',	'alpha' => 0.4),
			'alter_bg_color_02'	=> array('color' => 'alter_bg_color',	'alpha' => 0.2),
			'alter_bd_color_02'	=> array('color' => 'alter_bd_color',	'alpha' => 0.2),
			'extra_bg_color_07'	=> array('color' => 'extra_bg_color',	'alpha' => 0.7),
			'text_dark_07'		=> array('color' => 'text_dark',		'alpha' => 0.7),
			'text_dark_02'		=> array('color' => 'text_dark',		'alpha' => 0.2),
			'text_link_02'		=> array('color' => 'text_link',		'alpha' => 0.2),
			'text_link_07'		=> array('color' => 'text_link',		'alpha' => 0.7),
			'text_link_blend'	=> array('color' => 'text_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5),
			'alter_link_blend'	=> array('color' => 'alter_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		militarology_storage_set('theme_thumbs', apply_filters('militarology_filter_add_thumb_sizes', array(
			'militarology-thumb-huge'		=> array(
												'size'	=> array(1170, 658, true),
												'title' => esc_html__( 'Huge image', 'militarology' ),
												'subst'	=> 'trx_addons-thumb-huge'
												),
			'militarology-thumb-big' 		=> array(
												'size'	=> array( 740, 409, true),
												'title' => esc_html__( 'Large image', 'militarology' ),
												'subst'	=> 'trx_addons-thumb-big'
												),

			'militarology-thumb-med' 		=> array(
												'size'	=> array( 370, 215, true),
												'title' => esc_html__( 'Medium image', 'militarology' ),
												'subst'	=> 'trx_addons-thumb-medium'
												),

                'militarology-thumb-little' 		=> array(
                    'size'	=> array( 256, 131, true),
                    'title' => esc_html__( 'Little image', 'militarology' ),
                    'subst'	=> 'trx_addons-thumb-little'
                ),

                'militarology-thumb-serv' 		=> array(
                    'size'	=> array( 586, 248, true),
                    'title' => esc_html__( 'Service image', 'militarology' ),
                    'subst'	=> 'trx_addons-thumb-serv'
                ),

                'militarology-thumb-wider' 		=> array(
                    'size'	=> array( 392, 126, true),
                    'title' => esc_html__( 'Wider image', 'militarology' ),
                    'subst'	=> 'trx_addons-thumb-wider'
                ),

			'militarology-thumb-tiny' 		=> array(
												'size'	=> array(  90,  90, true),
												'title' => esc_html__( 'Small square avatar', 'militarology' ),
												'subst'	=> 'trx_addons-thumb-tiny'
												),

			'militarology-thumb-masonry-big' => array(
												'size'	=> array( 760,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry Large (scaled)', 'militarology' ),
												'subst'	=> 'trx_addons-thumb-masonry-big'
												),

			'militarology-thumb-masonry'		=> array(
												'size'	=> array( 370,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry (scaled)', 'militarology' ),
												'subst'	=> 'trx_addons-thumb-masonry'
												)
			))
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'militarology_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'militarology_importer_set_options', 9 );
	function militarology_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url(militarology_get_protocol() . '://demofiles.ancorathemes.com/militarology/');
			// Required plugins
			$options['required_plugins'] = array_keys(militarology_storage_get('required_plugins'));
			// Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title'] = esc_html__('Militarology Demo', 'militarology');
			$options['files']['default']['domain_dev'] = esc_url('http://national-military.dv.ancorathemes.com');		// Developers domain
			$options['files']['default']['domain_demo']= esc_url('http://militarology.ancorathemes.com');		// Demo-site domain

			// Banners
			$options['banners'] = array(
				array(
					'image' => militarology_get_file_url('theme-specific/theme.about/images/frontpage.png'),
					'title' => esc_html__('Front page Builder', 'militarology'),
					'content' => wp_kses(__('Create your Frontpage right in WordPress Customizer! To do this, you will not need neither the WPBakery Page Builder nor any other Builder. Just turn on/off sections, and fill them with content and decorate to your liking', 'militarology'), 'militarology_kses_content' ),
					'link_url' => esc_url('//www.youtube.com/watch?v=VT0AUbMl_KA'),
					'link_caption' => esc_html__('More about Frontpage Builder', 'militarology'),
					'duration' => 20
					),
				array(
					'image' => militarology_get_file_url('theme-specific/theme.about/images/layouts.png'),
					'title' => esc_html__('Custom layouts', 'militarology'),
					'content' => wp_kses(__('Forget about problems with customization of header or footer! You can edit any of layout without any changes in CSS or HTML directly in Visual Builder. Moreover - you can easily create your own headers and footers and use them along with built-in', 'militarology'), 'militarology_kses_content' ),
					'link_url' => esc_url('//www.youtube.com/watch?v=pYhdFVLd7y4'),
					'link_caption' => esc_html__('More about Custom Layouts', 'militarology'),
					'duration' => 20
					),
				array(
					'image' => militarology_get_file_url('theme-specific/theme.about/images/documentation.png'),
					'title' => esc_html__('Read full documentation', 'militarology'),
					'content' => wp_kses(__('Need more details? Please check our full online documentation for detailed information on how to use Militarology', 'militarology'), 'militarology_kses_content' ),
					'link_url' => esc_url(militarology_storage_get('theme_doc_url')),
					'link_caption' => esc_html__('Online documentation', 'militarology'),
					'duration' => 15
					),
				array(
					'image' => militarology_get_file_url('theme-specific/theme.about/images/video-tutorials.png'),
					'title' => esc_html__('Video tutorials', 'militarology'),
					'content' => wp_kses(__('No time for reading documentation? Check out our video tutorials and learn how to customize Militarology in detail.', 'militarology'), 'militarology_kses_content' ),
					'link_url' => esc_url(militarology_storage_get('theme_video_url')),
					'link_caption' => esc_html__('Video tutorials', 'militarology'),
					'duration' => 15
					),
				array(
					'image' => militarology_get_file_url('theme-specific/theme.about/images/studio.png'),
					'title' => esc_html__('Website Customization', 'militarology'),
					'content' => wp_kses(__('We can make a website based on this theme for a very fair price.
We can implement any extra functional: translate your website, WPML implementation and many other customization accroding to your request.', 'militarology'), 'militarology_kses_content' ),
					'link_url' => esc_url('//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash/'),
					'link_caption' => esc_html__('Contact us', 'militarology'),
					'duration' => 25
					)
				);
		}
		return $options;
	}
}




// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('militarology_create_theme_options')) {

	function militarology_create_theme_options() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __('<b>Attention!</b> Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'militarology');

		militarology_storage_set('options', array(
		
			// 'Logo & Site Identity'
			'title_tagline' => array(
				"title" => esc_html__('Logo & Site Identity', 'militarology'),
				"desc" => '',
				"priority" => 10,
				"type" => "section"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo in the header', 'militarology'),
				"desc" => '',
				"priority" => 20,
				"type" => "info",
				),
			'logo_text' => array(
				"title" => esc_html__('Use Site Name as Logo', 'militarology'),
				"desc" => wp_kses_data( __('Use the site title and tagline as a text logo if no image is selected', 'militarology') ),
				"class" => "militarology_column-1_2 militarology_new_row",
				"priority" => 30,
				"std" => 1,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_retina_enabled' => array(
				"title" => esc_html__('Allow retina display logo', 'militarology'),
				"desc" => wp_kses_data( __('Show fields to select logo images for Retina display', 'militarology') ),
				"class" => "militarology_column-1_2",
				"priority" => 40,
				"refresh" => false,
				"std" => 0,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_max_height' => array(
				"title" => esc_html__('Logo max. height', 'militarology'),
				"desc" => wp_kses_data( __("Max. height of the logo image (in pixels). Maximum size of logo depends on the actual size of the picture", 'militarology') ),
				"std" => 80,
				"min" => 20,
				"max" => 160,
				"step" => 1,
				"refresh" => false,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "slider"
				),
			// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'militarology') ),
				"class" => "militarology_column-1_2",
				"priority" => 70,
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile_header' => array(
				"title" => esc_html__('Logo for the mobile header', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'militarology') ),
				"class" => "militarology_column-1_2 militarology_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_header_retina' => array(
				"title" => esc_html__('Logo for the mobile header for Retina', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'militarology') ),
				"class" => "militarology_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile' => array(
				"title" => esc_html__('Logo mobile', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile menu', 'militarology') ),
				"class" => "militarology_column-1_2 militarology_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_retina' => array(
				"title" => esc_html__('Logo mobile for Retina', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'militarology') ),
				"class" => "militarology_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'militarology') ),
				"class" => "militarology_column-1_2 militarology_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'militarology') ),
				"class" => "militarology_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "image"
				),
			
		
		
			// 'General settings'
			'general' => array(
				"title" => esc_html__('General Settings', 'militarology'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 20,
				"type" => "section",
				),

			'general_layout_info' => array(
				"title" => esc_html__('Layout', 'militarology'),
				"desc" => '',
				"type" => "info",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'militarology'),
				"desc" => wp_kses_data( __('Select width of the body content', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'militarology')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => militarology_get_list_body_styles(),
				"type" => "select"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'militarology') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'militarology')
				),
				"std" => '',
				"hidden" => true,
				"type" => "image"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'militarology'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'militarology')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),

			'general_sidebar_info' => array(
				"title" => esc_html__('Sidebar', 'militarology'),
				"desc" => '',
				"type" => "info",
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'militarology'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'militarology')
				),
				"std" => 'right',
				"options" => array(),
				"type" => "switch"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'militarology'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'militarology')
				),
				"dependency" => array(
					'sidebar_position' => array('left', 'right')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'militarology'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'militarology') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),


			'general_widgets_info' => array(
				"title" => esc_html__('Additional widgets', 'militarology'),
				"desc" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info",
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'militarology'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'militarology')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'militarology'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'militarology')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'militarology'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'militarology')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'militarology'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'militarology')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
				),

			'general_effects_info' => array(
				"title" => esc_html__('Design & Effects', 'militarology'),
				"desc" => '',
				"type" => "info",
				),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'militarology'),
				"desc" => wp_kses_data( __('Specify the border radius of the form fields and buttons in pixels or other valid CSS units', 'militarology') ),
				"std" => 0,
				"type" => "text"
				),

			'general_misc_info' => array(
				"title" => esc_html__('Miscellaneous', 'militarology'),
				"desc" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info",
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'militarology'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'militarology') ),
				"std" => 0,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),

            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'militarology'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'militarology') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'militarology'), 'militarology_kses_content' ),
                "type"  => "text"
            ),
		
		
			// 'Header'
			'header' => array(
				"title" => esc_html__('Header', 'militarology'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 30,
				"type" => "section"
				),

			'header_style_info' => array(
				"title" => esc_html__('Header style', 'militarology'),
				"desc" => '',
				"type" => "info"
				),
			'header_type' => array(
				"title" => esc_html__('Header style', 'militarology'),
				"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"std" => 'default',
				"options" => militarology_get_list_header_footer_types(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
				),
			'header_style' => array(
				"title" => esc_html__('Select custom layout', 'militarology'),
				"desc" => wp_kses( __("Select custom header from Layouts Builder", 'militarology'), 'militarology_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"dependency" => array(
					'header_type' => array('custom')
				),
				"std" => MILITAROLOGY_THEME_FREE ? 'header-default' : 'header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'militarology'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"std" => 'default',
				"options" => array(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'militarology'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"std" => 0,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_zoom' => array(
				"title" => esc_html__('Header zoom', 'militarology'),
				"desc" => wp_kses_data( __("Zoom the header title. 1 - original size", 'militarology') ),
				"std" => 1,
				"min" => 0.3,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "slider"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'militarology'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 1,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_widgets_info' => array(
				"title" => esc_html__('Header widgets', 'militarology'),
				"desc" => wp_kses_data( __('Here you can place a widget slider, advertising banners, etc.', 'militarology') ),
				"type" => "info"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'militarology'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'militarology') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'militarology'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"dependency" => array(
					'header_type' => array('default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => militarology_get_list_range(0,6),
				"type" => "select"
				),

			'menu_info' => array(
				"title" => esc_html__('Main menu', 'militarology'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'militarology') ),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'militarology'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'militarology'),
					'left'	=> esc_html__('Left',	'militarology'),
					'right'	=> esc_html__('Right',	'militarology')
				),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'militarology'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'militarology'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'militarology')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'militarology'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'militarology') ),
				"std" => 1,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_image_info' => array(
				"title" => esc_html__('Header image', 'militarology'),
				"desc" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'militarology'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'militarology') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'militarology')
				),
				"std" => 0,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_mobile_info' => array(
				"title" => esc_html__('Mobile header', 'militarology'),
				"desc" => wp_kses_data( __("Configure the mobile version of the header", 'militarology') ),
				"priority" => 500,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info"
				),
			'header_mobile_enabled' => array(
				"title" => esc_html__('Enable the mobile header', 'militarology'),
				"desc" => wp_kses_data( __("Use the mobile version of the header (if checked) or relayout the current header on mobile devices", 'militarology') ),
				"std" => 0,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_additional_info' => array(
				"title" => esc_html__('Additional info', 'militarology'),
				"desc" => wp_kses_data( __('Additional info to show at the top of the mobile header', 'militarology') ),
				"std" => '',
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"refresh" => false,
				"teeny" => false,
				"rows" => 20,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "text_editor"
				),
			'header_mobile_hide_info' => array(
				"title" => esc_html__('Hide additional info', 'militarology'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_logo' => array(
				"title" => esc_html__('Hide logo', 'militarology'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_login' => array(
				"title" => esc_html__('Hide login/logout', 'militarology'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_search' => array(
				"title" => esc_html__('Hide search', 'militarology'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_cart' => array(
				"title" => esc_html__('Hide cart', 'militarology'),
				"std" => 0,
				"dependency" => array(
					'header_mobile_enabled' => array(1)
				),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
				),


		
			// 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'militarology'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 50,
				"type" => "section"
				),
			'footer_type' => array(
				"title" => esc_html__('Footer style', 'militarology'),
				"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'militarology')
				),
				"std" => 'default',
				"options" => militarology_get_list_header_footer_types(),
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
				),
			'footer_style' => array(
				"title" => esc_html__('Select custom layout', 'militarology'),
				"desc" => wp_kses( __("Select custom footer from Layouts Builder", 'militarology'), 'militarology_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'militarology')
				),
				"dependency" => array(
					'footer_type' => array('custom')
				),
				"std" => MILITAROLOGY_THEME_FREE ? 'footer-default' : 'footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'militarology'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'militarology')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'militarology'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'militarology') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'militarology')
				),
				"dependency" => array(
					'footer_type' => array('default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => militarology_get_list_range(0,6),
				"type" => "select"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'militarology'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'militarology') ),
				'refresh' => false,
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'militarology') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1)
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'militarology') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1),
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'militarology'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'militarology') ),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'militarology'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'militarology') ),
				"std" => esc_html__('Copyright &copy; {Y} by  AncoraThemes. All rights reserved.', 'militarology'),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
			
		
		
			// 'Blog'
			'blog' => array(
				"title" => esc_html__('Blog', 'militarology'),
				"desc" => wp_kses_data( __('Options of the the blog archive', 'militarology') ),
				"priority" => 70,
				"type" => "panel",
				),
		
				// Blog - Posts page
				'blog_general' => array(
					"title" => esc_html__('Posts page', 'militarology'),
					"desc" => wp_kses_data( __('Style and components of the blog archive', 'militarology') ),
					"type" => "section",
					),
				'blog_general_info' => array(
					"title" => esc_html__('General settings', 'militarology'),
					"desc" => '',
					"type" => "info",
					),
				'blog_style' => array(
					"title" => esc_html__('Blog style', 'militarology'),
					"desc" => '',
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => 'excerpt',
					"options" => array(),
					"type" => "select"
					),
				'first_post_large' => array(
					"title" => esc_html__('First post large', 'militarology'),
					"desc" => wp_kses_data( __('Make your first post stand out by making it bigger', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('classic', 'masonry')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				"blog_content" => array( 
					"title" => esc_html__('Posts content', 'militarology'),
					"desc" => wp_kses_data( __("Display either post excerpts or the full post content", 'militarology') ),
					"std" => "excerpt",
					"dependency" => array(
						'blog_style' => array('excerpt')
					),
					"options" => array(
						'excerpt'	=> esc_html__('Excerpt',	'militarology'),
						'fullpost'	=> esc_html__('Full post',	'militarology')
					),
					"type" => "switch"
					),
				'excerpt_length' => array(
					"title" => esc_html__('Excerpt length', 'militarology'),
					"desc" => wp_kses_data( __("Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged", 'militarology') ),
					"dependency" => array(
						'blog_style' => array('excerpt'),
						'blog_content' => array('excerpt')
					),
					"std" => 60,
					"type" => "text"
					),
				'blog_columns' => array(
					"title" => esc_html__('Blog columns', 'militarology'),
					"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'militarology') ),
					"std" => 2,
					"options" => militarology_get_list_range(2,4),
					"type" => "hidden"
					),
				'post_type' => array(
					"title" => esc_html__('Post type', 'militarology'),
					"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"linked" => 'parent_cat',
					"refresh" => false,
					"hidden" => true,
					"std" => 'post',
					"options" => array(),
					"type" => "select"
					),
				'parent_cat' => array(
					"title" => esc_html__('Category to show', 'militarology'),
					"desc" => wp_kses_data( __('Select category to show in the blog archive', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"refresh" => false,
					"hidden" => true,
					"std" => '0',
					"options" => array(),
					"type" => "select"
					),
				'posts_per_page' => array(
					"title" => esc_html__('Posts per page', 'militarology'),
					"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"hidden" => true,
					"std" => '',
					"type" => "text"
					),
				"blog_pagination" => array( 
					"title" => esc_html__('Pagination style', 'militarology'),
					"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"std" => "pages",
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"options" => array(
						'pages'	=> esc_html__("Page numbers", 'militarology'),
						'links'	=> esc_html__("Older/Newest", 'militarology'),
						'more'	=> esc_html__("Load more", 'militarology'),
						'infinite' => esc_html__("Infinite scroll", 'militarology')
					),
					"type" => "select"
					),
				'show_filters' => array(
					"title" => esc_html__('Show filters', 'militarology'),
					"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('portfolio', 'gallery')
					),
					"hidden" => true,
					"std" => 0,
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
					),
	
				'blog_sidebar_info' => array(
					"title" => esc_html__('Sidebar', 'militarology'),
					"desc" => '',
					"type" => "info",
					),
				'sidebar_position_blog' => array(
					"title" => esc_html__('Sidebar position', 'militarology'),
					"desc" => wp_kses_data( __('Select position to show sidebar', 'militarology') ),
					"std" => 'right',
					"options" => array(),
					"type" => "switch"
					),
				'sidebar_widgets_blog' => array(
					"title" => esc_html__('Sidebar widgets', 'militarology'),
					"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'militarology') ),
					"dependency" => array(
						'sidebar_position_blog' => array('left', 'right')
					),
					"std" => 'sidebar_widgets',
					"options" => array(),
					"type" => "select"
					),
				'expand_content_blog' => array(
					"title" => esc_html__('Expand content', 'militarology'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'militarology') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
	
	
				'blog_widgets_info' => array(
					"title" => esc_html__('Additional widgets', 'militarology'),
					"desc" => '',
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info",
					),
				'widgets_above_page_blog' => array(
					"title" => esc_html__('Widgets at the top of the page', 'militarology'),
					"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'militarology') ),
					"std" => 'hide',
					"options" => array(),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),
				'widgets_above_content_blog' => array(
					"title" => esc_html__('Widgets above the content', 'militarology'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'militarology') ),
					"std" => 'hide',
					"options" => array(),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_content_blog' => array(
					"title" => esc_html__('Widgets below the content', 'militarology'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'militarology') ),
					"std" => 'hide',
					"options" => array(),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_page_blog' => array(
					"title" => esc_html__('Widgets at the bottom of the page', 'militarology'),
					"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'militarology') ),
					"std" => 'hide',
					"options" => array(),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),

				'blog_advanced_info' => array(
					"title" => esc_html__('Advanced settings', 'militarology'),
					"desc" => '',
					"type" => "info",
					),
				'no_image' => array(
					"title" => esc_html__('Image placeholder', 'militarology'),
					"desc" => wp_kses_data( __('Select or upload an image used as placeholder for posts without a featured image', 'militarology') ),
					"std" => '',
					"type" => "image"
					),
				'time_diff_before' => array(
					"title" => esc_html__('Easy Readable Date Format', 'militarology'),
					"desc" => wp_kses_data( __("For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'militarology') ),
					"std" => 5,
					"type" => "text"
					),
				'sticky_style' => array(
					"title" => esc_html__('Sticky posts style', 'militarology'),
					"desc" => wp_kses_data( __('Select style of the sticky posts output', 'militarology') ),
					"std" => 'inherit',
					"options" => array(
						'inherit' => esc_html__('Decorated posts', 'militarology'),
						'columns' => esc_html__('Mini-cards',	'militarology')
					),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),
				"blog_animation" => array( 
					"title" => esc_html__('Animation for the posts', 'militarology'),
					"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => "none",
					"options" => array(),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),
				'meta_parts' => array(
					"title" => esc_html__('Post meta', 'militarology'),
					"desc" => wp_kses_data( __("If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page.", 'militarology') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=0|counters=0|author=0|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'militarology'),
						'date'		 => esc_html__('Post date', 'militarology'),
						'author'	 => esc_html__('Post author', 'militarology'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'militarology'),
						'share'		 => esc_html__('Share links', 'militarology'),
						'edit'		 => esc_html__('Edit link', 'militarology')
					),
					"type" => "hidden"
				),
				'counters' => array(
					"title" => esc_html__('Views, Likes and Comments', 'militarology'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'militarology') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'militarology')
					),
					"dependency" => array(
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=1|likes=0|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'militarology'),
						'likes' => esc_html__('Likes', 'militarology'),
						'comments' => esc_html__('Comments', 'militarology')
					),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checklist"
				),

				
				// Blog - Single posts
				'blog_single' => array(
					"title" => esc_html__('Single posts', 'militarology'),
					"desc" => wp_kses_data( __('Settings of the single post', 'militarology') ),
					"type" => "section",
					),
				'hide_featured_on_single' => array(
					"title" => esc_html__('Hide featured image on the single post', 'militarology'),
					"desc" => wp_kses_data( __("Hide featured image on the single post's pages", 'militarology') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'militarology')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'hide_sidebar_on_single' => array(
					"title" => esc_html__('Hide sidebar on the single post', 'militarology'),
					"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'militarology') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'show_post_meta' => array(
					"title" => esc_html__('Show post meta', 'militarology'),
					"desc" => wp_kses_data( __("Display block with post's meta: date, categories, counters, etc.", 'militarology') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'meta_parts_post' => array(
					"title" => esc_html__('Post meta', 'militarology'),
					"desc" => wp_kses_data( __("Meta parts for single posts.", 'militarology') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=0|counters=0|author=0|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'militarology'),
						'date'		 => esc_html__('Post date', 'militarology'),
						'author'	 => esc_html__('Post author', 'militarology'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'militarology'),
						'share'		 => esc_html__('Share links', 'militarology'),
						'edit'		 => esc_html__('Edit link', 'militarology')
					),
					"type" => "hidden"
				),
				'counters_post' => array(
					"title" => esc_html__('Views, Likes and Comments', 'militarology'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'militarology') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=1|likes=1|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'militarology'),
						'likes' => esc_html__('Likes', 'militarology'),
						'comments' => esc_html__('Comments', 'militarology')
					),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checklist"
				),
				'show_share_links' => array(
					"title" => esc_html__('Show share links', 'militarology'),
					"desc" => wp_kses_data( __("Display share links on the single post", 'militarology') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'show_author_info' => array(
					"title" => esc_html__('Show author info', 'militarology'),
					"desc" => wp_kses_data( __("Display block with information about post's author", 'militarology') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'blog_single_related_info' => array(
					"title" => esc_html__('Related posts', 'militarology'),
					"desc" => '',
					"type" => "info",
					),
				'show_related_posts' => array(
					"title" => esc_html__('Show related posts', 'militarology'),
					"desc" => wp_kses_data( __("Show section 'Related posts' on the single post's pages", 'militarology') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'militarology')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'related_posts' => array(
					"title" => esc_html__('Related posts', 'militarology'),
					"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts showed.', 'militarology') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => militarology_get_list_range(1,9),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
					),
				'related_columns' => array(
					"title" => esc_html__('Related columns', 'militarology'),
					"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page (from 2 to 4)?', 'militarology') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => militarology_get_list_range(1,4),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
					),
				'related_style' => array(
					"title" => esc_html__('Related posts style', 'militarology'),
					"desc" => wp_kses_data( __('Select style of the related posts output', 'militarology') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => militarology_get_list_styles(1,2),
					"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
					),
			'blog_end' => array(
				"type" => "panel_end",
				),
			
		
		
			// 'Colors'
			'panel_colors' => array(
				"title" => esc_html__('Colors', 'militarology'),
				"desc" => '',
				"priority" => 300,
				"type" => "section"
				),

			'color_schemes_info' => array(
				"title" => esc_html__('Color schemes', 'militarology'),
				"desc" => wp_kses_data( __('Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'militarology') ),
				"type" => "info",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'militarology'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'militarology')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'militarology'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'militarology')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Sidemenu Color Scheme', 'militarology'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'militarology')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'militarology'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'militarology')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'militarology'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'militarology')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),

			'color_scheme_editor_info' => array(
				"title" => esc_html__('Color scheme editor', 'militarology'),
				"desc" => wp_kses_data(__('Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'militarology') ),
				"type" => "info",
				),
			'scheme_storage' => array(
				"title" => esc_html__('Color scheme editor', 'militarology'),
				"desc" => '',
				"std" => '$militarology_get_scheme_storage',
				"refresh" => false,
				"colorpicker" => "tiny",
				"type" => "scheme_editor"
				),


			// 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'militarology'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'militarology') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'militarology')
				),
				"hidden" => true,
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'militarology'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'militarology') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'militarology')
				),
				"hidden" => true,
				"std" => '',
				"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			// Use huge priority to call render this elements after all options!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"priority" => 10000,
				"type" => "hidden",
				),

			'last_option' => array(		// Need to manually call action to include Tiny MCE scripts
				"title" => '',
				"desc" => '',
				"std" => 1,
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// 'Fonts'
			'fonts' => array(
				"title" => esc_html__('Typography', 'militarology'),
				"desc" => '',
				"priority" => 200,
				"type" => "panel"
				),

			// Fonts - Load_fonts
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'militarology'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'militarology') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'militarology') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'militarology'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'militarology') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'militarology') ),
				"class" => "militarology_column-1_3 militarology_new_row",
				"refresh" => false,
				"std" => '$militarology_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=militarology_get_theme_setting('max_load_fonts'); $i++) {
			if (militarology_get_value_gp('page') != 'theme_options') {
				$fonts["load_fonts-{$i}-info"] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					"title" => esc_html(sprintf(__('Font %s', 'militarology'), $i)),
					"desc" => '',
					"type" => "info",
					);
			}
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'militarology'),
				"desc" => '',
				"class" => "militarology_column-1_3 militarology_new_row",
				"refresh" => false,
				"std" => '$militarology_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'militarology'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'militarology') )
							: '',
				"class" => "militarology_column-1_3",
				"refresh" => false,
				"std" => '$militarology_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'militarology'),
					'serif' => esc_html__('serif', 'militarology'),
					'sans-serif' => esc_html__('sans-serif', 'militarology'),
					'monospace' => esc_html__('monospace', 'militarology'),
					'cursive' => esc_html__('cursive', 'militarology'),
					'fantasy' => esc_html__('fantasy', 'militarology')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'militarology'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'militarology') )
								. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'militarology') )
							: '',
				"class" => "militarology_column-1_3",
				"refresh" => false,
				"std" => '$militarology_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = militarology_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html(sprintf(__('%s settings', 'militarology'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								// Translators: Add tag's name to make description
								: wp_kses_post( sprintf(__('Font settings of the "%s" tag.', 'militarology'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'militarology'),
						'100' => esc_html__('100 (Light)', 'militarology'), 
						'200' => esc_html__('200 (Light)', 'militarology'), 
						'300' => esc_html__('300 (Thin)',  'militarology'),
						'400' => esc_html__('400 (Normal)', 'militarology'),
						'500' => esc_html__('500 (Semibold)', 'militarology'),
						'600' => esc_html__('600 (Semibold)', 'militarology'),
						'700' => esc_html__('700 (Bold)', 'militarology'),
						'800' => esc_html__('800 (Black)', 'militarology'),
						'900' => esc_html__('900 (Black)', 'militarology')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'militarology'),
						'normal' => esc_html__('Normal', 'militarology'), 
						'italic' => esc_html__('Italic', 'militarology')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'militarology'),
						'none' => esc_html__('None', 'militarology'), 
						'underline' => esc_html__('Underline', 'militarology'),
						'overline' => esc_html__('Overline', 'militarology'),
						'line-through' => esc_html__('Line-through', 'militarology')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'militarology'),
						'none' => esc_html__('None', 'militarology'), 
						'uppercase' => esc_html__('Uppercase', 'militarology'),
						'lowercase' => esc_html__('Lowercase', 'militarology'),
						'capitalize' => esc_html__('Capitalize', 'militarology')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"class" => "militarology_column-1_5",
					"refresh" => false,
					"std" => '$militarology_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters to Theme Options
		militarology_storage_set_array_before('options', 'panel_colors', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			militarology_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'militarology'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'militarology') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'militarology')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		if (!function_exists('the_custom_logo') || (isset($_REQUEST['page']) && $_REQUEST['page']=='theme_options')) {
			militarology_storage_set_array_before('options', 'logo_retina', function_exists('the_custom_logo') ? 'custom_logo' : 'logo', array(
				"title" => esc_html__('Logo', 'militarology'),
				"desc" => wp_kses_data( __('Select or upload the site logo', 'militarology') ),
				"class" => "militarology_column-1_2 militarology_new_row",
				"priority" => 60,
				"std" => '',
				"type" => "image"
				)
			);
		}
	}
}


// Returns a list of options that can be overridden for CPT
if (!function_exists('militarology_options_get_list_cpt_options')) {
	function militarology_options_get_list_cpt_options($cpt, $title='') {
		if (empty($title)) $title = ucfirst($cpt);
		return array(
					"header_info_{$cpt}" => array(
						"title" => esc_html__('Header', 'militarology'),
						"desc" => '',
						"type" => "info",
						),
					"header_type_{$cpt}" => array(
						"title" => esc_html__('Header style', 'militarology'),
						"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'militarology') ),
						"std" => 'inherit',
						"options" => militarology_get_list_header_footer_types(true),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
						),
					"header_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'militarology'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select custom layout to display the site header on the %s pages', 'militarology'), $title) ),
						"dependency" => array(
							"header_type_{$cpt}" => array('custom')
						),
						"std" => 'inherit',
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
						),
					"header_position_{$cpt}" => array(
						"title" => esc_html__('Header position', 'militarology'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to display the site header on the %s pages', 'militarology'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
						),
					"header_image_override_{$cpt}" => array(
						"title" => esc_html__('Header image override', 'militarology'),
						"desc" => wp_kses_data( __("Allow override the header image with the post's featured image", 'militarology') ),
						"std" => 0,
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "checkbox"
						),
					"header_widgets_{$cpt}" => array(
						"title" => esc_html__('Header widgets', 'militarology'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select set of widgets to show in the header on the %s pages', 'militarology'), $title) ),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
						
					"sidebar_info_{$cpt}" => array(
						"title" => esc_html__('Sidebar', 'militarology'),
						"desc" => '',
						"type" => "info",
						),
					"sidebar_position_{$cpt}" => array(
						"title" => esc_html__('Sidebar position', 'militarology'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to show sidebar on the %s pages', 'militarology'), $title) ),
						"refresh" => false,
						"std" => 'left',
						"options" => array(),
						"type" => "switch"
						),
					"sidebar_widgets_{$cpt}" => array(
						"title" => esc_html__('Sidebar widgets', 'militarology'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select sidebar to show on the %s pages', 'militarology'), $title) ),
						"dependency" => array(
							"sidebar_position_{$cpt}" => array('left', 'right')
						),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
					"hide_sidebar_on_single_{$cpt}" => array(
						"title" => esc_html__('Hide sidebar on the single pages', 'militarology'),
						"desc" => wp_kses_data( __("Hide sidebar on the single page", 'militarology') ),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"footer_info_{$cpt}" => array(
						"title" => esc_html__('Footer', 'militarology'),
						"desc" => '',
						"type" => "info",
						),
					"footer_type_{$cpt}" => array(
						"title" => esc_html__('Footer style', 'militarology'),
						"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'militarology') ),
						"std" => 'inherit',
						"options" => militarology_get_list_header_footer_types(true),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "switch"
						),
					"footer_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'militarology'),
						"desc" => wp_kses_data( __('Select custom layout to display the site footer', 'militarology') ),
						"std" => 'inherit',
						"dependency" => array(
							"footer_type_{$cpt}" => array('custom')
						),
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
						),
					"footer_widgets_{$cpt}" => array(
						"title" => esc_html__('Footer widgets', 'militarology'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'militarology') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 'footer_widgets',
						"options" => array(),
						"type" => "select"
						),
					"footer_columns_{$cpt}" => array(
						"title" => esc_html__('Footer columns', 'militarology'),
						"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'militarology') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default'),
							"footer_widgets_{$cpt}" => array('^hide')
						),
						"std" => 0,
						"options" => militarology_get_list_range(0,6),
						"type" => "select"
						),
					"footer_wide_{$cpt}" => array(
						"title" => esc_html__('Footer fullwide', 'militarology'),
						"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'militarology') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"widgets_info_{$cpt}" => array(
						"title" => esc_html__('Additional panels', 'militarology'),
						"desc" => '',
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "info",
						),
					"widgets_above_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the top of the page', 'militarology'),
						"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'militarology') ),
						"std" => 'hide',
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
						),
					"widgets_above_content_{$cpt}" => array(
						"title" => esc_html__('Widgets above the content', 'militarology'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'militarology') ),
						"std" => 'hide',
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_content_{$cpt}" => array(
						"title" => esc_html__('Widgets below the content', 'militarology'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'militarology') ),
						"std" => 'hide',
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the bottom of the page', 'militarology'),
						"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'militarology') ),
						"std" => 'hide',
						"options" => array(),
						"type" => MILITAROLOGY_THEME_FREE ? "hidden" : "select"
						)
					);
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('militarology_options_get_list_choises')) {
	add_filter('militarology_filter_options_get_list_choises', 'militarology_options_get_list_choises', 10, 2);
	function militarology_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = militarology_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = militarology_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (substr($id, -7) == '_scheme')
				$list = militarology_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = militarology_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = militarology_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = militarology_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = militarology_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = militarology_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = militarology_array_merge(array(0 => esc_html__('- Select category -', 'militarology')), militarology_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = militarology_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = militarology_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = militarology_get_list_load_fonts(true);
		}
		return $list;
	}
}
?>