<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_post_id    = get_the_ID();
$militarology_post_date  = militarology_get_date();
$militarology_post_title = get_the_title();
$militarology_post_link  = get_permalink();
$militarology_post_author_id   = get_the_author_meta('ID');
$militarology_post_author_name = get_the_author_meta('display_name');
$militarology_post_author_url  = get_author_posts_url($militarology_post_author_id, '');

$militarology_args = get_query_var('militarology_args_widgets_posts');
$militarology_show_date = isset($militarology_args['show_date']) ? (int) $militarology_args['show_date'] : 1;
$militarology_show_image = isset($militarology_args['show_image']) ? (int) $militarology_args['show_image'] : 1;
$militarology_show_author = isset($militarology_args['show_author']) ? (int) $militarology_args['show_author'] : 1;
$militarology_show_counters = isset($militarology_args['show_counters']) ? (int) $militarology_args['show_counters'] : 1;
$militarology_show_categories = isset($militarology_args['show_categories']) ? (int) $militarology_args['show_categories'] : 1;

$militarology_output = militarology_storage_get('militarology_output_widgets_posts');

$militarology_post_counters_output = '';
if ( $militarology_show_counters ) {
	$militarology_post_counters_output = '<span class="post_info_item post_info_counters">'
								. militarology_get_post_counters('comments')
							. '</span>';
}


$militarology_output .= '<article class="post_item with_thumb">';

if ($militarology_show_image) {
	$militarology_post_thumb = get_the_post_thumbnail($militarology_post_id, militarology_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
	));
	if ($militarology_post_thumb) $militarology_output .= '<div class="post_thumb">' . ($militarology_post_link ? '<a href="' . esc_url($militarology_post_link) . '">' : '') . ($militarology_post_thumb) . ($militarology_post_link ? '</a>' : '') . '</div>';
}

$militarology_output .= '<div class="post_content">'
			. ($militarology_show_categories 
					? '<div class="post_categories">'
						. militarology_get_post_categories()
						. $militarology_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($militarology_post_link ? '<a href="' . esc_url($militarology_post_link) . '">' : '') . ($militarology_post_title) . ($militarology_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('militarology_filter_get_post_info', 
								'<div class="post_info">'
									. ($militarology_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($militarology_post_link ? '<a href="' . esc_url($militarology_post_link) . '" class="post_info_date">' : '') 
											. esc_html($militarology_post_date) 
											. ($militarology_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($militarology_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'militarology') . ' ' 
											. ($militarology_post_link ? '<a href="' . esc_url($militarology_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($militarology_post_author_name) 
											. ($militarology_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$militarology_show_categories && $militarology_post_counters_output
										? $militarology_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
militarology_storage_set('militarology_output_widgets_posts', $militarology_output);
?>