<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

// Header sidebar
$militarology_header_name = militarology_get_theme_option('header_widgets');
$militarology_header_present = !militarology_is_off($militarology_header_name) && is_active_sidebar($militarology_header_name);
if ($militarology_header_present) { 
	militarology_storage_set('current_sidebar', 'header');
	$militarology_header_wide = militarology_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($militarology_header_name) ) {
		dynamic_sidebar($militarology_header_name);
	}
	$militarology_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($militarology_widgets_output)) {
		$militarology_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $militarology_widgets_output);
		$militarology_need_columns = strpos($militarology_widgets_output, 'columns_wrap')===false;
		if ($militarology_need_columns) {
			$militarology_columns = max(0, (int) militarology_get_theme_option('header_columns'));
			if ($militarology_columns == 0) $militarology_columns = min(6, max(1, substr_count($militarology_widgets_output, '<aside ')));
			if ($militarology_columns > 1)
				$militarology_widgets_output = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($militarology_columns).' widget', $militarology_widgets_output);
			else
				$militarology_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($militarology_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$militarology_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($militarology_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'militarology_action_before_sidebar' );
				militarology_show_layout($militarology_widgets_output);
				do_action( 'militarology_action_after_sidebar' );
				if ($militarology_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$militarology_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>