<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.14
 */
$militarology_header_video = militarology_get_header_video();
$militarology_embed_video = '';
if (!empty($militarology_header_video) && !militarology_is_from_uploads($militarology_header_video)) {
	if (militarology_is_youtube_url($militarology_header_video) && preg_match('/[=\/]([^=\/]*)$/', $militarology_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$militarology_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($militarology_header_video) . '[/embed]' ));
			$militarology_embed_video = militarology_make_video_autoplay($militarology_embed_video);
		} else {
			$militarology_header_video = str_replace('/watch?v=', '/embed/', $militarology_header_video);
			$militarology_header_video = militarology_add_to_url($militarology_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$militarology_embed_video = '<iframe src="' . esc_url($militarology_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php militarology_show_layout($militarology_embed_video); ?></div><?php
	}
}
?>