<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

// Page (category, tag, archive, author) title

if ( !is_home() && militarology_need_page_title() ) {
	militarology_sc_layouts_showed('title', true);
	militarology_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php

						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$militarology_blog_title = militarology_get_blog_title();
							$militarology_blog_title_text = $militarology_blog_title_class = $militarology_blog_title_link = $militarology_blog_title_link_text = '';
							if (is_array($militarology_blog_title)) {
								$militarology_blog_title_text = $militarology_blog_title['text'];
								$militarology_blog_title_class = !empty($militarology_blog_title['class']) ? ' '.$militarology_blog_title['class'] : '';
								$militarology_blog_title_link = !empty($militarology_blog_title['link']) ? $militarology_blog_title['link'] : '';
								$militarology_blog_title_link_text = !empty($militarology_blog_title['link_text']) ? $militarology_blog_title['link_text'] : '';
							} else
								$militarology_blog_title_text = $militarology_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($militarology_blog_title_class); ?>"><?php
								$militarology_top_icon = militarology_get_category_icon();
								if (!empty($militarology_top_icon)) {
									$militarology_attr = militarology_getimagesize($militarology_top_icon);
									?><img src="<?php echo esc_url($militarology_top_icon); ?>" alt="<?php esc_attr__('Image', 'militarology')?>" <?php if (!empty($militarology_attr[3])) militarology_show_layout($militarology_attr[3]);?>><?php
								}
								echo wp_kses_post($militarology_blog_title_text);
							?></h1>
							<?php
							if (!empty($militarology_blog_title_link) && !empty($militarology_blog_title_link_text)) {
								?><a href="<?php echo esc_url($militarology_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($militarology_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'militarology_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>