<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_args = get_query_var('militarology_logo_args');

// Site logo
$militarology_logo_type   = isset($militarology_args['type']) ? $militarology_args['type'] : '';
$militarology_logo_image  = militarology_get_logo_image($militarology_logo_type);
$militarology_logo_text   = militarology_is_on(militarology_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$militarology_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($militarology_logo_image) || !empty($militarology_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url(home_url('/')); ?>"><?php
		if (!empty($militarology_logo_image)) {
			if (empty($militarology_logo_type) && function_exists('the_custom_logo') && (int) $militarology_logo_image > 0) {
				the_custom_logo();
			} else {
				$militarology_attr = militarology_getimagesize($militarology_logo_image);
				echo '<img src="'.esc_url($militarology_logo_image).'" alt="'.esc_attr__('Image', 'militarology').'"'.(!empty($militarology_attr[3]) ? ' '.wp_kses_data($militarology_attr[3]) : '').'>';
			}
		} else {
			militarology_show_layout(militarology_prepare_macros($militarology_logo_text), '<span class="logo_text">', '</span>');
			militarology_show_layout(militarology_prepare_macros($militarology_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>