<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.06
 */

$militarology_header_css = $militarology_header_image = '';
$militarology_header_video = militarology_get_header_video();
if (true || empty($militarology_header_video)) {
	$militarology_header_image = get_header_image();
	if (militarology_trx_addons_featured_image_override(true)) $militarology_header_image = militarology_get_current_mode_image($militarology_header_image);
}

$militarology_header_id = str_replace('header-custom-', '', militarology_get_theme_option("header_style"));
if ((int) $militarology_header_id == 0) {
	$militarology_header_id = militarology_get_post_id(array(
												'name' => $militarology_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$militarology_header_id = apply_filters('militarology_filter_get_translated_layout', $militarology_header_id);
}
$militarology_header_meta = get_post_meta($militarology_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($militarology_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($militarology_header_id)));
				echo !empty($militarology_header_image) || !empty($militarology_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($militarology_header_video!='') 
					echo ' with_bg_video';
				if ($militarology_header_image!='') 
					echo ' '.esc_attr(militarology_add_inline_css_class('background-image: url('.esc_url($militarology_header_image).');'));
				if (!empty($militarology_header_meta['margin']) != '') 
					echo ' '.esc_attr(militarology_add_inline_css_class('margin-bottom: '.esc_attr(militarology_prepare_css_value($militarology_header_meta['margin'])).';'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (militarology_is_on(militarology_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight militarology-full-height';
				?> scheme_<?php echo esc_attr(militarology_is_inherit(militarology_get_theme_option('header_scheme')) 
												? militarology_get_theme_option('color_scheme') 
												: militarology_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($militarology_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('militarology_action_show_layout', $militarology_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>