<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.10
 */

// Footer sidebar
$militarology_footer_name = militarology_get_theme_option('footer_widgets');
$militarology_footer_present = !militarology_is_off($militarology_footer_name) && is_active_sidebar($militarology_footer_name);
if ($militarology_footer_present) { 
	militarology_storage_set('current_sidebar', 'footer');
	$militarology_footer_wide = militarology_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($militarology_footer_name) ) {
		dynamic_sidebar($militarology_footer_name);
	}
	$militarology_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($militarology_out)) {
		$militarology_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $militarology_out);
		$militarology_need_columns = true;
		if ($militarology_need_columns) {
			$militarology_columns = max(0, (int) militarology_get_theme_option('footer_columns'));
			if ($militarology_columns == 0) $militarology_columns = min(4, max(1, substr_count($militarology_out, '<aside ')));
			if ($militarology_columns > 1)
				$militarology_out = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($militarology_columns).' widget', $militarology_out);
			else
				$militarology_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($militarology_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$militarology_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($militarology_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'militarology_action_before_sidebar' );
				militarology_show_layout($militarology_out);
				do_action( 'militarology_action_after_sidebar' );
				if ($militarology_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$militarology_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>