<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.10
 */

// Logo
if (militarology_is_on(militarology_get_theme_option('logo_in_footer'))) {
	$militarology_logo_image = '';
	if (militarology_is_on(militarology_get_theme_option('logo_retina_enabled')) && militarology_get_retina_multiplier(2) > 1)
		$militarology_logo_image = militarology_get_theme_option( 'logo_footer_retina' );
	if (empty($militarology_logo_image)) 
		$militarology_logo_image = militarology_get_theme_option( 'logo_footer' );
	$militarology_logo_text   = get_bloginfo( 'name' );
	if (!empty($militarology_logo_image) || !empty($militarology_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($militarology_logo_image)) {
					$militarology_attr = militarology_getimagesize($militarology_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($militarology_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('Image', 'militarology').'"'.(!empty($militarology_attr[3]) ? ' ' . wp_kses_data($militarology_attr[3]) : '').'></a>' ;
				} else if (!empty($militarology_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($militarology_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>