<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.10
 */

$militarology_footer_scheme =  militarology_is_inherit(militarology_get_theme_option('footer_scheme')) ? militarology_get_theme_option('color_scheme') : militarology_get_theme_option('footer_scheme');
$militarology_footer_id = str_replace('footer-custom-', '', militarology_get_theme_option("footer_style"));
if ((int) $militarology_footer_id == 0) {
	$militarology_footer_id = militarology_get_post_id(array(
												'name' => $militarology_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$militarology_footer_id = apply_filters('militarology_filter_get_translated_layout', $militarology_footer_id);
}
$militarology_footer_meta = get_post_meta($militarology_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($militarology_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($militarology_footer_id))); 
						if (!empty($militarology_footer_meta['margin']) != '') 
							echo ' '.esc_attr(militarology_add_inline_css_class('margin-top: '.militarology_prepare_css_value($militarology_footer_meta['margin']).';'));
						?> scheme_<?php echo esc_attr($militarology_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('militarology_action_show_layout', $militarology_footer_id);
	?>
</footer><!-- /.footer_wrap -->
