<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0.10
 */

// Copyright area
$militarology_footer_scheme =  militarology_is_inherit(militarology_get_theme_option('footer_scheme')) ? militarology_get_theme_option('color_scheme') : militarology_get_theme_option('footer_scheme');
$militarology_copyright_scheme = militarology_is_inherit(militarology_get_theme_option('copyright_scheme')) ? $militarology_footer_scheme : militarology_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($militarology_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$militarology_copyright = militarology_prepare_macros(militarology_get_theme_option('copyright'));
				if (!empty($militarology_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $militarology_copyright, $militarology_matches)) {
						$militarology_copyright = str_replace($militarology_matches[1], date_i18n(str_replace(array('{', '}'), '', $militarology_matches[1])), $militarology_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($militarology_copyright));
				}
			?></div>
		</div>
	</div>
</div>
