<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

if (militarology_sidebar_present()) {
	ob_start();
	$militarology_sidebar_name = militarology_get_theme_option('sidebar_widgets');
	militarology_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($militarology_sidebar_name) ) {
		dynamic_sidebar($militarology_sidebar_name);
	}
	$militarology_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($militarology_out)) {
		$militarology_sidebar_position = militarology_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($militarology_sidebar_position); ?> widget_area<?php if (!militarology_is_inherit(militarology_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(militarology_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'militarology_action_before_sidebar' );
				militarology_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $militarology_out));
				do_action( 'militarology_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>