<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'militarology_trx_updater_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'militarology_trx_updater_theme_setup9', 9 );
    function militarology_trx_updater_theme_setup9() {
        if ( is_admin() ) {
            add_filter( 'militarology_filter_tgmpa_required_plugins', 'militarology_trx_updater_tgmpa_required_plugins', 8 );
        }
    }
}


// Filter to add in the required plugins list
if ( ! function_exists( 'militarology_trx_updater_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('militarology_filter_tgmpa_required_plugins', 'militarology_trx_updater_tgmpa_required_plugins');
    function militarology_trx_updater_tgmpa_required_plugins( $list = array() ) {
        if ( militarology_storage_isset( 'required_plugins', 'trx_updater' ) ) {
            $path = militarology_get_file_dir( 'plugins/trx_updater/trx_updater.zip' );
            if ( ! empty( $path ) || militarology_get_theme_setting( 'tgmpa_upload' ) ) {
                $list[] = array(
                    'name'     => militarology_storage_get_array( 'required_plugins', 'trx_updater' ),
                    'slug'     => 'trx_updater',
                    'version'  => '1.4.1',
                    'source'   => ! empty( $path ) ? $path : 'upload://trx_updater.zip',
                    'required' => true,
                );
            }
        }
        return $list;
    }
}


// Check if plugin installed and activated
if ( ! function_exists( 'militarology_exists_trx_updater' ) ) {
    function militarology_exists_trx_updater() {
        return defined( 'TRX_UPDATER_VERSION' );
    }
}
