<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('militarology_trx_addons_get_mycss')) {
	add_filter('militarology_filter_get_css', 'militarology_trx_addons_get_mycss', 10, 4);
	function militarology_trx_addons_get_mycss($css, $colors, $fonts, $scheme='') {

        if (isset($css['fonts']) && $fonts) {
            $css['fonts'] .= <<<CSS

CSS;
        }

        if (isset($css['colors']) && $colors) {
            $css['colors'] .= <<<CSS
            
            /* Inline colors */
            .trx_addons_accent,
            .trx_addons_accent_big,
            .trx_addons_accent > a,
            .trx_addons_accent > * {
                color: {$colors['text_link']};
            }
            .trx_addons_accent_hovered,
            .trx_addons_accent_hovered,
            .trx_addons_accent_hovered > a,
            .trx_addons_accent_hovered > * {
                color: {$colors['text_hover']};
            }
            .trx_addons_accent_bg {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }

            
            /* Tooltip */
            .trx_addons_tooltip {
                color: {$colors['text']};
                border-color: {$colors['text']};
            }
            .trx_addons_tooltip:before {
                background-color: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            .trx_addons_tooltip:after {
                border-top-color: {$colors['text_dark']};
            }
            
            
            /* Dropcaps */
            .trx_addons_dropcap_style_1 {
                background-color: {$colors['text_hover']};
                color: {$colors['inverse_link']};
            }
            .trx_addons_dropcap_style_2 {
               background-color: {$colors['bg_color_0']};
                color: {$colors['text_dark']};
            }
            
            
            /* Blockqoute */
            blockquote {
                color: {$colors['inverse_link']};
                background: {$colors['text_link']};
            }
            blockquote cite a,
            blockquote > a, blockquote > p > a,
            blockquote > cite, blockquote > p > cite {
                color: {$colors['inverse_link']};
            }
            blockquote cite a:hover,
            blockquote > a, blockquote > p > a:hover {
                color: {$colors['text_hover']};
            }
            blockquote:before {
                color: {$colors['inverse_link']};
            }
            
            /* Images */
            figure figcaption,
            .wp-caption .wp-caption-text,
            .wp-caption .wp-caption-dd,
            .wp-caption-overlay .wp-caption .wp-caption-text,
            .wp-caption-overlay .wp-caption .wp-caption-dd {
                color: {$colors['inverse_link']};
                background: linear-gradient(to top, {$colors['inverse_dark']} 0%, {$colors['bg_color_0']} 100%);
            }
            figure figcaption a:hover{
                color: {$colors['extra_dark']};
            }
            
            
            /* Lists */
            ul[class*="trx_addons_list_custom"] > li:before {
                color: {$colors['alter_light']};
                background-color: {$colors['bg_color_0']};
            }
            .trx_addons_list_custom li {
                color: {$colors['text_dark']};
            }
          
            
            /* Table */
            table th {
                color: {$colors['extra_text']};
                background-color: {$colors['text_dark']};
            }
            table th, table th + th, table td + th  {
                border-color: {$colors['extra_bd_color']};
            }
            table td, table th + td, table td + td {
                color: {$colors['text']};
                border-color: {$colors['alter_bd_color']};
            }
            table > tbody > tr:nth-child(2n+1) > td {
                background-color: {$colors['alter_bg_hover']};
            }
            table > tbody > tr:nth-child(2n) > td {
                background-color: {$colors['alter_bg_color']};
            }

            /* Main menu */
            .sc_layouts_menu_nav>li>a {
                color: {$colors['text']} !important;
            }
            .sc_layouts_menu_nav>li>a:hover,
            .sc_layouts_menu_nav>li.sfHover>a,
            .sc_layouts_menu_nav>li.current-menu-item>a,
            .sc_layouts_menu_nav>li.current-menu-parent>a,
            .sc_layouts_menu_nav>li.current-menu-ancestor>a {
                color: {$colors['text_dark']} !important;
            }
            
            /* Dropdown menu */
            .sc_layouts_menu_nav>li ul{
                background-color: {$colors['text_dark']};
            }
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a,
            .sc_layouts_menu_nav>li li>a {
                color: {$colors['extra_text']} !important;
            }
            .sc_layouts_menu_nav>li li>a:hover:after,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a:hover,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li.sfHover>a,
            .sc_layouts_menu_nav>li li>a:hover,
            .sc_layouts_menu_nav>li li.sfHover>a,
            .sc_layouts_menu_nav>li li.current-menu-item>a,
            .sc_layouts_menu_nav>li li.current-menu-parent>a,
            .sc_layouts_menu_nav>li li.current-menu-ancestor>a {
                color: {$colors['inverse_text']} !important;
                background-color: {$colors['bg_color_0']};
            }
            .sc_layouts_menu_nav > li,
            .sc_layouts_row.sc_layouts_row_type_compact .sc_layouts_item + .sc_layouts_item {
                border-color: {$colors['extra_bg_color']};
            }
            .sc_layouts_menu_nav > li > a:before {
                border-color: {$colors['text_dark']};
            }
            
            /* Breadcrumbs */
            .sc_layouts_title_caption {
                color: {$colors['text_dark']};
            }
            .sc_layouts_title_breadcrumbs,
            .sc_layouts_title_breadcrumbs a {
                color: {$colors['text_dark']} !important;
            }
            .breadcrumbs_item.current{
                color: {$colors['text_dark']} !important;
            }
            .sc_layouts_title_breadcrumbs a:hover {
                color: {$colors['text_link']} !important;
            }
            
            /* Slider */
            .sc_slider_controls .slider_controls_wrap > a,
            .slider_container.slider_controls_side .slider_controls_wrap > a,
            .slider_outer_controls_side .slider_controls_wrap > a {
                color: {$colors['inverse_link']};
                background-color: {$colors['bg_color_0']};
            }
            .sc_slider_controls .slider_controls_wrap > a:hover,
            .slider_container.slider_controls_side .slider_controls_wrap > a:hover,
            .slider_outer_controls_side .slider_controls_wrap > a:hover {
                 color: {$colors['text_link']};
                 background-color: {$colors['bg_color_0']};
            }
            
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet,
            .swiper-pagination-custom .swiper-pagination-button {
                background-color: {$colors['inverse_link']};
            }
            .swiper-pagination-custom .swiper-pagination-button.swiper-pagination-button-active,
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet:hover,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet:hover {
                background-color: {$colors['inverse_link']};
            }
            
            
            /* Layouts */
            .sc_layouts_logo .logo_text {
                color: {$colors['text_dark']};
            }
            

            /* Shortcodes */
            .sc_skills_pie.sc_skills_compact_off .sc_skills_total {
                color: {$colors['text_dark']};
            }
            .sc_skills_pie.sc_skills_compact_off .sc_skills_item_title {
                color: {$colors['text_dark']};
            }
            .sc_countdown .sc_countdown_label,
            .sc_countdown_default .sc_countdown_digits span {
                color: {$colors['text_dark']};
                background: {$colors['bg_color_0']};
            }
            .sc_skills_counter .sc_skills_icon  {
                color: {$colors['text_dark']};
                border-color: {$colors['input_bd_color']};
            }
            
            /* Audio */
            .trx_addons_audio_player.without_cover,
            .format-audio .post_featured.without_thumb .post_audio {
                background: {$colors['bg_color']};
                border-color: {$colors['input_bd_color']};
            }
            .mejs-controls .mejs-button {
                background: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            footer .mejs-controls .mejs-button {
                background: {$colors['extra_bg_hover']};
                color: {$colors['inverse_link']};
            }
            .mejs-controls .mejs-button:hover {
                background: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .trx_addons_audio_player .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total:before, 
            .trx_addons_audio_player .mejs-controls .mejs-time-rail .mejs-time-total:before {
                background: {$colors['extra_light']};
            }
            .mejs-controls .mejs-time-rail .mejs-time-total,
            .mejs-controls .mejs-time-rail .mejs-time-loaded,
            .mejs-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total {
                background: {$colors['extra_light']};
            }
            .without_thumb .mejs-controls .mejs-currenttime,
            .without_thumb .mejs-controls .mejs-duration,
            .trx_addons_audio_player .mejs-container .mejs-controls .mejs-time {
                color: {$colors['text']};
            }
            .format-audio .post_featured .post_audio_author,
            .trx_addons_audio_player.without_cover .audio_author {
                color: {$colors['text']};
            }
            .format-audio .post_featured.without_thumb .post_audio_title,
            .format-audio .post_featured .post_audio_title, .trx_addons_audio_player .audio_caption {
                color: {$colors['text_dark']};
            }
            
            
            /* Video */
            .trx_addons_video_player.with_cover .video_hover,
            .format-video .post_featured.with_thumb .post_video_hover {
                color: {$colors['text_hover']};
                background-color: {$colors['inverse_link']};
            }
            .trx_addons_video_player.with_cover .video_hover:hover,
            .format-video .post_featured.with_thumb .post_video_hover:hover {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_hover']};
            }
            
            /* Price */
            .sc_price .trx_addons_columns_wrap>div:last-child .sc_price_item,
            .sc_price_item {
                color: {$colors['text_dark']};
                background-color: {$colors['bg_color']};
                border-color: {$colors['extra_light']};
            }
            .sc_price_item:hover {
                 color: {$colors['text_dark']};
                background-color: {$colors['bg_color']};
                border-color: {$colors['extra_light']};
            }
            .sc_price_item:hover .sc_price_item_title,
            .sc_price_item .sc_price_item_title,
            .sc_price_item .sc_price_item_title a {
                color: {$colors['text_dark']};
            }
            .sc_price_item:hover .sc_price_item_title a {
                color: {$colors['text_link']};
            }
            .sc_price_item .sc_price_item_price {
                color: {$colors['text_link']};
            }
            .sc_price_item .sc_price_item_description{
                color: {$colors['text_dark']};
                border-color: {$colors['bd_color']};
            }
            .sc_price_item .sc_price_item_details {
                color: {$colors['text_dark']};
            }
            .sc_price_item_details ul li + li {
                border-color: {$colors['bd_color']};
            }
            
            .scheme_self.sidebar .sidebar_inner .widget.widget_search{
                background-color: {$colors['text_link']};
                border-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:after {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:hover:after {
                color: {$colors['text_dark']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"] {
                background-color: {$colors['bg_color_0']};
                color: {$colors['inverse_link']};
                border-color: {$colors['bg_color_0']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"]::-webkit-input-placeholder {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"]::-moz-placeholder {
                color: {$colors['inverse_link']};
            }
            
            li.recentcomments > a {
                color: {$colors['text']};
            }
            .comment-author-link {
                color: {$colors['text_dark']};
            }
            .scheme_self.footer_wrap .widget ul li a {
                color: {$colors['text']};
            }
            .scheme_self.footer_wrap .widget ul li a:hover {
                color: {$colors['text_link']};
            }
            .sc_layouts_row_type_narrow .sc_layouts_item a:hover .sc_layouts_iconed_text_line1 {
                color: {$colors['text_dark']};
            }
            .footer_wrap .scheme_self.vc_row.sc_layouts_row_type_narrow .search_wrap .search_field::-webkit-input-placeholder {
                color: {$colors['alter_light']};
            }
            
            .footer_wrap .scheme_self.vc_row.sc_layouts_row_type_narrow .search_wrap .search_submit:before,
            .footer_wrap .scheme_self.vc_row.sc_layouts_row_type_narrow  a,
            .footer_wrap .scheme_self.vc_row.sc_layouts_row_type_narrow {
                color: {$colors['alter_light']};
            }
            .footer_wrap .scheme_self.vc_row.sc_layouts_row_type_narrow .search_wrap .search_submit:hover:before,
            .footer_wrap .scheme_self.vc_row.sc_layouts_row_type_narrow a:hover {
                    color: {$colors['text_dark']};            
            }
            .sc_testimonials_item_content:before {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_link']};
            }
            .sc_testimonials_item_content {
                  color: {$colors['text']};  
            }
            .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};
            }
            .sc_item_subtitle,
            .sc_action_item .sc_action_item_subtitle {
                color: {$colors['extra_text']};
            }
            .sc_icons .sc_icons_icon {
                color: {$colors['text_dark']};
            }
            .sc_icons .trx_addons_columns_wrap .sc_icons_item,
            .sc_icons .trx_addons_columns_wrap > div:last-child .sc_icons_item   {
             color: {$colors['text_dark']};
                background-color: {$colors['bg_color']};
                border-color: {$colors['extra_light']};
            }
            .sc_icons .sc_icons_item_linked:hover  .sc_icons_icon,
            .sc_icons .sc_icons_item_linked:hover .sc_icons_item_description {
                color: {$colors['text_link']};
            }
            .sc_googlemap_content .sc_form .sc_form_field input[type="text"], .sc_googlemap_content .sc_form .sc_form_field textarea {
                border-color: {$colors['input_bd_color']};
            }
            
            .sc_services_alt .serv-image .sc_services_item_title a,
            .sc_services_alt .serv-image .sc_services_item_title {
                color: {$colors['inverse_link']};
            }
            .trx_addons_list_custom li a:hover,
            .sc_services_light .sc_services_item_icon {
                color: {$colors['text_dark']};
            }
            .sc_services_light .sc_services_columns_wrap,
            .sc_services_light .sc_services_columns_wrap .sc_services_item {
                border-color: {$colors['input_bd_color']};
            }
            .trx_addons_list_custom li a,
            .sc_services_light .sc_services_item:hover .sc_services_item_icon {
                color: {$colors['text_link']};
            }
            .scheme_dark h4 a {
                color: {$colors['text']};
            }
            .scheme_dark h4 a:hover {
                color: {$colors['text_link']};
            }
            .big_title .sc_item_descr {
                color: {$colors['alter_dark']};
            }
            
            .sc_courses_default .sc_courses_item {
                background-color: {$colors['bg_color_0']};
            }
            .sc_services_hovers  .sc_services_columns_wrap .sc_services_item,
            .sc_services_hovers .sc_services_columns_wrap,
            .sc_courses .sc_courses_columns_wrap .sc_courses_item,
            .sc_courses .sc_courses_columns_wrap {
                border-color: {$colors['input_bd_color']};
            }
            .sc_courses .sc_courses_columns_wrap .sc_courses_item:hover .sc_courses_item_title,
            .sc_courses_item_title:after,
            .sc_courses .sc_courses_columns_wrap .sc_courses_item:hover a,
            .sc_courses .sc_courses_columns_wrap .sc_courses_item:hover a:hover,
            .sc_courses .sc_courses_columns_wrap .sc_courses_item:hover {
                color: {$colors['inverse_link']};
            }
            .sc_courses .sc_courses_columns_wrap .sc_courses_item:hover {
                background-color: {$colors['text_link']};
            }
            .sc_services_default .sc_services_item {
                background-color: {$colors['bg_color']};
                color: {$colors['text']};
            }
            .DownButton:hover i:before,
            .custom.tparrows:hover:before {
                color: {$colors['text_link']};
            }
            .sc_services_hovers .sc_services_item_info {
                background-color: {$colors['bg_color']};
            }
            .sc_services_hovers .sc_services_columns_wrap .sc_services_item:hover * {
                color: {$colors['inverse_link']};
            }
            .scheme_dark .sc_courses_default .sc_courses_item_title {
                color: {$colors['text']};
            }
            .scheme_dark .sc_courses .sc_courses_columns_wrap .sc_courses_item, 
            .scheme_dark .sc_courses .sc_courses_columns_wrap {
                border-color: {$colors['extra_bd_hover']};
            }
            .scheme_dark .wpcf7 input[type="submit"],
            .scheme_dark .sc_button.color_style_dark:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image),
            .scheme_dark .sc_courses .sc_item_button .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image) {
                background-color: {$colors['bg_color']};
                color: {$colors['text_dark']};
            }
            .scheme_dark .sc_button.color_style_dark:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover {
                background-color: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            .scheme_dark .wpcf7 input[type="submit"]:hover,
            .scheme_dark .sc_courses .sc_item_button .sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .sc_services_hover .sc_services_item_header {
                background-color: {$colors['bg_color_0']};
                color: {$colors['text_dark']};
            }
            .sc_services_hover .sc_services_item_content {
                background-color: {$colors['input_bd_hover']};
                color: {$colors['inverse_link']};
            }    
            .sc_services_hover .sc_services_item_title a, 
            .sc_services_hover .sc_services_item_icon {
                color: {$colors['text_dark']} !important;
            }     
            .sc_services_hover .sc_services_item_content .sc_services_item_title a {
                color: {$colors['inverse_link']}!important;
            } 
            .sc_services_hover .sc_services_columns_wrap.no_margin,
            .sc_services_hover .sc_services_columns_wrap.no_margin .sc_services_item {
                border-color: {$colors['input_bd_color']};
            }
            .sc_services_light .sc_services_item_featured_left .sc_services_item_number, .sc_services_light .sc_services_item_featured_right .sc_services_item_number {
                color: {$colors['text']};
            }
            .sc_services_light .sc_item_columns_1 .sc_services_item,
            .sc_services_light .sc_item_columns_1 {
                border-color: {$colors['extra_bg_color']};
            }
            .sc_services_light .sc_item_columns_1 .sc_services_item .sc_services_item_title a {
                color: {$colors['text']};
            }
            .sc_services_light .sc_item_columns_1 .sc_services_item:before,
            .sc_services_light .sc_services_item_featured_left:hover .sc_services_item_number,
            .sc_services_light .sc_item_columns_1 .sc_services_item:hover .sc_services_item_title a {
                color: {$colors['text_dark']};
            }
            .wpcf7-form-control-wrap select,
            .wpcf7-form-control-wrap input {
                border-color: {$colors['input_bd_color']} !important;
                color: {$colors['text_dark']};
            }
            .wpcf7-form-control-wrap input::-webkit-input-placeholder {
                color: {$colors['text']};
            }
            .scheme_self.sc_layouts_row_type_narrow .sc_layouts_item_details_line2 {
                color: {$colors['text']};
            }
            .sc_layouts_menu_nav .menu-collapse>a:hover:before,
            .scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:hover .social_icon,
            .scheme_self.sc_layouts_row_type_narrow .widget_nav_menu ul li a:hover,
            .scheme_self.sc_layouts_row_type_narrow .search_wrap .search_field:focus,
            .scheme_self.sc_layouts_row_type_narrow .sc_layouts_item a:hover .sc_layouts_item_icon,
            .scheme_self.sc_layouts_row_type_narrow .sc_layouts_item a:hover .sc_layouts_iconed_text_line1,
            .scheme_self.sc_layouts_row_type_narrow .sc_layouts_item a:hover .sc_layouts_iconed_text_line2 {
                color: {$colors['text_dark']};
            }
            .scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item .social_icon,
            .scheme_self.sc_layouts_row_type_narrow .widget_nav_menu ul li a {
                color: {$colors['alter_light']};
            }
            .top_panel_custom_599 .sc_layouts_row_type_compact.sc_layouts_row_fixed_on {
                background-color: {$colors['text_hover2']} !important;
            } 
            .sticky .brs,
            .sticky .bls,
            .sticky .post-bottom,
            .sticky .post-body {
                border-color: {$colors['text_link']};
            }
            .sc_services_hovers .sc_services_item > a {
                color: {$colors['bg_color_0']} !important;
            }
            

CSS;
		}

		return $css;
	}
}
?>