<?php
/* Give (donation forms) support functions
------------------------------------------------------------------------------- */

if ( ! defined( 'MILITAROLOGY_GIVE_FORMS_PT_FORMS' ) )			define( 'MILITAROLOGY_GIVE_FORMS_PT_FORMS', 'give_forms' );
if ( ! defined( 'MILITAROLOGY_GIVE_FORMS_PT_PAYMENT' ) )			define( 'MILITAROLOGY_GIVE_FORMS_PT_PAYMENT', 'give_payment' );
if ( ! defined( 'MILITAROLOGY_GIVE_FORMS_TAXONOMY_CATEGORY' ) )	define( 'MILITAROLOGY_GIVE_FORMS_TAXONOMY_CATEGORY', 'give_forms_category' );
if ( ! defined( 'MILITAROLOGY_GIVE_FORMS_TAXONOMY_TAG' ) )		define( 'MILITAROLOGY_GIVE_FORMS_TAXONOMY_TAG', 'give_forms_tag' );


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'militarology_give_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'militarology_give_theme_setup3', 3 );
	function militarology_give_theme_setup3() {
		if ( militarology_exists_give() ) {
			// Section 'Give'
			militarology_storage_merge_array(
				'options', '', array_merge(
					array(
						'give' => array(
							'title' => esc_html__( 'Give Donations', 'militarology' ),
							'desc'  => wp_kses_data( __( 'Select parameters to display the Give Donations pages', 'militarology' ) ),
							'type'  => 'section',
						),
					),
					militarology_options_get_list_cpt_options( 'give', esc_html__( 'Give Donations', 'militarology' ) )
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'militarology_give_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'militarology_give_theme_setup9', 9 );
	function militarology_give_theme_setup9() {
		if ( militarology_exists_give() ) {
			add_action( 'wp_enqueue_scripts', 'militarology_give_frontend_scripts', 1100 );
			add_filter( 'militarology_filter_merge_styles', 'militarology_give_merge_styles' );
			add_filter( 'militarology_filter_get_post_categories', 'militarology_give_get_post_categories');
			add_filter( 'militarology_filter_post_type_taxonomy', 'militarology_give_post_type_taxonomy', 10, 2 );
			add_filter( 'militarology_filter_detect_blog_mode', 'militarology_give_detect_blog_mode' );
		}
		if ( is_admin() ) {
			add_filter( 'militarology_filter_tgmpa_required_plugins', 'militarology_give_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'militarology_give_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('militarology_filter_tgmpa_required_plugins', 'militarology_give_tgmpa_required_plugins');
	function militarology_give_tgmpa_required_plugins( $list = array() ) {
		if ( militarology_storage_isset( 'required_plugins', 'give' ) ) {
			$list[] = array(
				'name'     => militarology_storage_get_array( 'required_plugins', 'give'),
				'slug'     => 'give',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'militarology_exists_give' ) ) {
	function militarology_exists_give() {
		return class_exists( 'Give' );
	}
}

// Enqueue styles for frontend
if ( ! function_exists( 'militarology_give_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'militarology_give_frontend_scripts', 1100 );
	function militarology_give_frontend_scripts() {
		if ( militarology_is_on( militarology_get_theme_option( 'debug_mode' ) ) ) {
			$militarology_url = militarology_get_file_url( 'plugins/give/give.css' );
			if ( '' != $militarology_url ) {
				wp_enqueue_style( 'militarology-give', $militarology_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'militarology_give_merge_styles' ) ) {
	//Handler of the add_filter('militarology_filter_merge_styles', 'militarology_give_merge_styles');
	function militarology_give_merge_styles( $list ) {
		$list[] = 'plugins/give/give.css';
		return $list;
	}
}

// Return true, if current page is any give page
if ( ! function_exists( 'militarology_is_give_page' ) ) {
	function militarology_is_give_page() {
		$rez = militarology_exists_give()
					&& ! is_search()
					&& (
						is_singular( MILITAROLOGY_GIVE_FORMS_PT_FORMS )
						|| is_post_type_archive( MILITAROLOGY_GIVE_FORMS_PT_FORMS )
						|| is_tax( MILITAROLOGY_GIVE_FORMS_TAXONOMY_CATEGORY )
						|| is_tax( MILITAROLOGY_GIVE_FORMS_TAXONOMY_TAG )
						|| ( function_exists( 'is_give_form' ) && is_give_form() )
						|| ( function_exists( 'is_give_category' ) && is_give_category() )
						|| ( function_exists( 'is_give_tag' ) && is_give_tag() )
						);
		return $rez;
	}
}

// Detect current blog mode
if ( ! function_exists( 'militarology_give_detect_blog_mode' ) ) {
	//Handler of the add_filter( 'militarology_filter_detect_blog_mode', 'militarology_give_detect_blog_mode' );
	function militarology_give_detect_blog_mode( $mode = '' ) {
		if ( militarology_is_give_page() ) {
			$mode = 'give';
		}
		return $mode;
	}
}

// Return taxonomy for current post type
if ( ! function_exists( 'militarology_give_post_type_taxonomy' ) ) {
	//Handler of the add_filter( 'militarology_filter_post_type_taxonomy',	'militarology_give_post_type_taxonomy', 10, 2 );
	function militarology_give_post_type_taxonomy( $tax = '', $post_type = '' ) {
		if ( militarology_exists_give() && MILITAROLOGY_GIVE_FORMS_PT_FORMS == $post_type ) {
			$tax = MILITAROLOGY_GIVE_FORMS_TAXONOMY_CATEGORY;
		}
		return $tax;
	}
}

// Show categories of the current product
if ( ! function_exists( 'militarology_give_get_post_categories' ) ) {
	//Handler of the add_filter( 'militarology_filter_get_post_categories', 'militarology_give_get_post_categories');
	function militarology_give_get_post_categories( $cats = '' ) {
		if ( get_post_type() == MILITAROLOGY_GIVE_FORMS_PT_FORMS ) {
			$cats = militarology_get_post_terms( ', ', get_the_ID(), MILITAROLOGY_GIVE_FORMS_TAXONOMY_CATEGORY );
		}
		return $cats;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (militarology_exists_give()) { require_once MILITAROLOGY_THEME_DIR . 'plugins/give/give-styles.php'; }