<?php
/* Date & Time Picker support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'militarology_date_time_picker_field_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'militarology_date_time_picker_field_theme_setup9', 9 );
	function militarology_date_time_picker_field_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'militarology_filter_tgmpa_required_plugins', 'militarology_date_time_picker_field_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'militarology_date_time_picker_field_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('militarology_filter_tgmpa_required_plugins',	'militarology_date_time_picker_field_tgmpa_required_plugins');
	function militarology_date_time_picker_field_tgmpa_required_plugins( $list = array() ) {
		if ( militarology_storage_isset( 'required_plugins', 'date-time-picker-field' ) ) {
			$list[] = array(
				'name'     => militarology_storage_get_array( 'required_plugins', 'date-time-picker-field' ),
				'slug'     => 'date-time-picker-field',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if this plugin installed and activated
if ( ! function_exists( 'militarology_exists_date_time_picker_field' ) ) {
	function militarology_exists_date_time_picker_field() {
		return class_exists( 'CMoreira\\Plugins\\DateTimePicker\\Init' );
	}
}

// Set plugin's specific importer options
if ( !function_exists( 'militarology_date_time_picker_field_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options',	'militarology_date_time_picker_field_importer_set_options' );
	function militarology_date_time_picker_field_importer_set_options($options=array()) {
		if ( militarology_exists_date_time_picker_field() && in_array('date-time-picker-field', $options['required_plugins']) ) {
			if (is_array($options)) {
				$options['additional_options'][] = 'dtpicker';
			}
		}
		return $options;
	}
}