<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

militarology_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	militarology_show_layout(get_query_var('blog_archive_start'));

	$militarology_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$militarology_sticky_out = militarology_get_theme_option('sticky_style')=='columns' 
							&& is_array($militarology_stickies) && count($militarology_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$militarology_cat = militarology_get_theme_option('parent_cat');
	$militarology_post_type = militarology_get_theme_option('post_type');
	$militarology_taxonomy = militarology_get_post_type_taxonomy($militarology_post_type);
	$militarology_show_filters = militarology_get_theme_option('show_filters');
	$militarology_tabs = array();
	if (!militarology_is_off($militarology_show_filters)) {
		$militarology_args = array(
			'type'			=> $militarology_post_type,
			'child_of'		=> $militarology_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $militarology_taxonomy,
			'pad_counts'	=> false
		);
		$militarology_portfolio_list = get_terms($militarology_args);
		if (is_array($militarology_portfolio_list) && count($militarology_portfolio_list) > 0) {
			$militarology_tabs[$militarology_cat] = esc_html__('All', 'militarology');
			foreach ($militarology_portfolio_list as $militarology_term) {
				if (isset($militarology_term->term_id)) $militarology_tabs[$militarology_term->term_id] = $militarology_term->name;
			}
		}
	}
	if (count($militarology_tabs) > 0) {
		$militarology_portfolio_filters_ajax = true;
		$militarology_portfolio_filters_active = $militarology_cat;
		$militarology_portfolio_filters_id = 'portfolio_filters';
		?>
		<div class="portfolio_filters militarology_tabs militarology_tabs_ajax">
			<ul class="portfolio_titles militarology_tabs_titles">
				<?php
				foreach ($militarology_tabs as $militarology_id=>$militarology_title) {
					?><li><a href="<?php echo esc_url(militarology_get_hash_link(sprintf('#%s_%s_content', $militarology_portfolio_filters_id, $militarology_id))); ?>" data-tab="<?php echo esc_attr($militarology_id); ?>"><?php echo esc_html($militarology_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$militarology_ppp = militarology_get_theme_option('posts_per_page');
			if (militarology_is_inherit($militarology_ppp)) $militarology_ppp = '';
			foreach ($militarology_tabs as $militarology_id=>$militarology_title) {
				$militarology_portfolio_need_content = $militarology_id==$militarology_portfolio_filters_active || !$militarology_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $militarology_portfolio_filters_id, $militarology_id)); ?>"
					class="portfolio_content militarology_tabs_content"
					data-blog-template="<?php echo esc_attr(militarology_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(militarology_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($militarology_ppp); ?>"
					data-post-type="<?php echo esc_attr($militarology_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($militarology_taxonomy); ?>"
					data-cat="<?php echo esc_attr($militarology_id); ?>"
					data-parent-cat="<?php echo esc_attr($militarology_cat); ?>"
					data-need-content="<?php echo (false===$militarology_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($militarology_portfolio_need_content) 
						militarology_show_portfolio_posts(array(
							'cat' => $militarology_id,
							'parent_cat' => $militarology_cat,
							'taxonomy' => $militarology_taxonomy,
							'post_type' => $militarology_post_type,
							'page' => 1,
							'sticky' => $militarology_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		militarology_show_portfolio_posts(array(
			'cat' => $militarology_cat,
			'parent_cat' => $militarology_cat,
			'taxonomy' => $militarology_taxonomy,
			'post_type' => $militarology_post_type,
			'page' => 1,
			'sticky' => $militarology_sticky_out
			)
		);
	}

	militarology_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>