<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

militarology_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	militarology_show_layout(get_query_var('blog_archive_start'));

	$militarology_classes = 'posts_container '
						. (substr(militarology_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap columns_padding_bottom' : 'masonry_wrap');
	$militarology_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$militarology_sticky_out = militarology_get_theme_option('sticky_style')=='columns' 
							&& is_array($militarology_stickies) && count($militarology_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($militarology_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$militarology_sticky_out) {
		if (militarology_get_theme_option('first_post_large') && !is_paged() && !in_array(militarology_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($militarology_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($militarology_sticky_out && !is_sticky()) {
			$militarology_sticky_out = false;
			?></div><div class="<?php echo esc_attr($militarology_classes); ?>"><?php
		}
		get_template_part( 'content', $militarology_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	militarology_show_pagination();

	militarology_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>