<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('militarology_storage_get')) {
	function militarology_storage_get($var_name, $default='') {
		global $MILITAROLOGY_STORAGE;
		return isset($MILITAROLOGY_STORAGE[$var_name]) ? $MILITAROLOGY_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('militarology_storage_set')) {
	function militarology_storage_set($var_name, $value) {
		global $MILITAROLOGY_STORAGE;
		$MILITAROLOGY_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('militarology_storage_empty')) {
	function militarology_storage_empty($var_name, $key='', $key2='') {
		global $MILITAROLOGY_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($MILITAROLOGY_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($MILITAROLOGY_STORAGE[$var_name][$key]);
		else
			return empty($MILITAROLOGY_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('militarology_storage_isset')) {
	function militarology_storage_isset($var_name, $key='', $key2='') {
		global $MILITAROLOGY_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($MILITAROLOGY_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($MILITAROLOGY_STORAGE[$var_name][$key]);
		else
			return isset($MILITAROLOGY_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('militarology_storage_inc')) {
	function militarology_storage_inc($var_name, $value=1) {
		global $MILITAROLOGY_STORAGE;
		if (empty($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = 0;
		$MILITAROLOGY_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('militarology_storage_concat')) {
	function militarology_storage_concat($var_name, $value) {
		global $MILITAROLOGY_STORAGE;
		if (empty($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = '';
		$MILITAROLOGY_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('militarology_storage_get_array')) {
	function militarology_storage_get_array($var_name, $key, $key2='', $default='') {
		global $MILITAROLOGY_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($MILITAROLOGY_STORAGE[$var_name][$key]) ? $MILITAROLOGY_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($MILITAROLOGY_STORAGE[$var_name][$key][$key2]) ? $MILITAROLOGY_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('militarology_storage_set_array')) {
	function militarology_storage_set_array($var_name, $key, $value) {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if ($key==='')
			$MILITAROLOGY_STORAGE[$var_name][] = $value;
		else
			$MILITAROLOGY_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('militarology_storage_set_array2')) {
	function militarology_storage_set_array2($var_name, $key, $key2, $value) {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if (!isset($MILITAROLOGY_STORAGE[$var_name][$key])) $MILITAROLOGY_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$MILITAROLOGY_STORAGE[$var_name][$key][] = $value;
		else
			$MILITAROLOGY_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('militarology_storage_merge_array')) {
	function militarology_storage_merge_array($var_name, $key, $value) {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if ($key==='')
			$MILITAROLOGY_STORAGE[$var_name] = array_merge($MILITAROLOGY_STORAGE[$var_name], $value);
		else
			$MILITAROLOGY_STORAGE[$var_name][$key] = array_merge($MILITAROLOGY_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('militarology_storage_set_array_after')) {
	function militarology_storage_set_array_after($var_name, $after, $key, $value='') {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if (is_array($key))
			militarology_array_insert_after($MILITAROLOGY_STORAGE[$var_name], $after, $key);
		else
			militarology_array_insert_after($MILITAROLOGY_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('militarology_storage_set_array_before')) {
	function militarology_storage_set_array_before($var_name, $before, $key, $value='') {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if (is_array($key))
			militarology_array_insert_before($MILITAROLOGY_STORAGE[$var_name], $before, $key);
		else
			militarology_array_insert_before($MILITAROLOGY_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('militarology_storage_push_array')) {
	function militarology_storage_push_array($var_name, $key, $value) {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($MILITAROLOGY_STORAGE[$var_name], $value);
		else {
			if (!isset($MILITAROLOGY_STORAGE[$var_name][$key])) $MILITAROLOGY_STORAGE[$var_name][$key] = array();
			array_push($MILITAROLOGY_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('militarology_storage_pop_array')) {
	function militarology_storage_pop_array($var_name, $key='', $defa='') {
		global $MILITAROLOGY_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($MILITAROLOGY_STORAGE[$var_name]) && is_array($MILITAROLOGY_STORAGE[$var_name]) && count($MILITAROLOGY_STORAGE[$var_name]) > 0) 
				$rez = array_pop($MILITAROLOGY_STORAGE[$var_name]);
		} else {
			if (isset($MILITAROLOGY_STORAGE[$var_name][$key]) && is_array($MILITAROLOGY_STORAGE[$var_name][$key]) && count($MILITAROLOGY_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($MILITAROLOGY_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('militarology_storage_inc_array')) {
	function militarology_storage_inc_array($var_name, $key, $value=1) {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if (empty($MILITAROLOGY_STORAGE[$var_name][$key])) $MILITAROLOGY_STORAGE[$var_name][$key] = 0;
		$MILITAROLOGY_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('militarology_storage_concat_array')) {
	function militarology_storage_concat_array($var_name, $key, $value) {
		global $MILITAROLOGY_STORAGE;
		if (!isset($MILITAROLOGY_STORAGE[$var_name])) $MILITAROLOGY_STORAGE[$var_name] = array();
		if (empty($MILITAROLOGY_STORAGE[$var_name][$key])) $MILITAROLOGY_STORAGE[$var_name][$key] = '';
		$MILITAROLOGY_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('militarology_storage_call_obj_method')) {
	function militarology_storage_call_obj_method($var_name, $method, $param=null) {
		global $MILITAROLOGY_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($MILITAROLOGY_STORAGE[$var_name]) ? $MILITAROLOGY_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($MILITAROLOGY_STORAGE[$var_name]) ? $MILITAROLOGY_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('militarology_storage_get_obj_property')) {
	function militarology_storage_get_obj_property($var_name, $prop, $default='') {
		global $MILITAROLOGY_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($MILITAROLOGY_STORAGE[$var_name]->$prop) ? $MILITAROLOGY_STORAGE[$var_name]->$prop : $default;
	}
}
?>