<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_seo = militarology_is_on(militarology_get_theme_option('seo_snippets'));
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post_item_single post_type_'.esc_attr(get_post_type()) 
												. ' post_format_'.esc_attr(str_replace('post-format-', '', get_post_format())) 
												);
		if ($militarology_seo) {
			?> itemscope="itemscope" 
			   itemprop="articleBody" 
			   itemtype="//schema.org/<?php echo esc_attr(militarology_get_markup_schema()); ?>"
			   itemid="<?php echo esc_url(get_the_permalink()); ?>"
			   content="<?php the_title_attribute(); ?>"<?php
		}
?>><?php

	do_action('militarology_action_before_post_data'); 

	// Structured data snippets
	if ($militarology_seo)
		get_template_part('templates/seo');

	// Featured image
	if ( militarology_is_off(militarology_get_theme_option('hide_featured_on_single'))
			&& !militarology_sc_layouts_showed('featured') 
			&& strpos(get_the_content(), '[trx_widget_banner]')===false) {
		do_action('militarology_action_before_post_featured'); 
		militarology_show_post_featured();
		do_action('militarology_action_after_post_featured'); 
	} else if (has_post_thumbnail()) {
		?><meta itemprop="image" itemtype="//schema.org/ImageObject" content="<?php echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>"><?php
	}

	// Title and post meta
	if ( (!militarology_sc_layouts_showed('title')) && !in_array(get_post_format(), array('link', 'aside', 'status', 'quote')) ) {
		do_action('militarology_action_before_post_title'); 
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if (!militarology_sc_layouts_showed('title')) {
				the_title( '<h3 class="post_title entry-title"'.($militarology_seo ? ' itemprop="headline"' : '').'>', '</h3>' );
			}
			?>
		</div><!-- .post_header -->
		<?php
		do_action('militarology_action_after_post_title'); 
	}

	do_action('militarology_action_before_post_content'); 

	// Post content
	?>
	<div class="post_content entry-content post-sngl" itemprop="mainEntityOfPage">
		<?php

        // Post meta

        militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
                'components' => 'date',
                'counters' => '',
                'seo' => false
            ), 'excerpt', 1)
        );
		the_content( );

		do_action('militarology_action_before_post_pagination'); 

		wp_link_pages( array(
			'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'militarology' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'militarology' ) . ' </span>%',
			'separator'   => '<span class="screen-reader-text">, </span>',
		) );

		// Taxonomies and share
		if ( is_single() && !is_attachment() ) {
			
			do_action('militarology_action_before_post_meta'); 

			?><div class="post_meta post_meta_single"><div class="post-bottom"><div class="bls"><?php
				
				// Post taxonomies
				the_tags( '<span class="post_meta_item post_tags"> ', ', ', '</span>' );

                    $militarology_components = 'counters';

                    $militarology_counters = militarology_is_inherit(militarology_get_theme_option_from_meta('counters'))
                        ? 'views,comments'
                        : militarology_array_get_keys_by_value(militarology_get_theme_option('counters'));

                    if (!empty($militarology_components))
                        militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
                                'components' => $militarology_components,
                                'counters' => $militarology_counters,
                                'seo' => false
                            ), 'excerpt', 1)
                        );

                    ?></div><?php if (militarology_exists_trx_addons()) {?><div class="brs"><?php
				// Share
				if (militarology_is_on(militarology_get_theme_option('show_share_links'))) {
					militarology_show_share_links(array(
							'type' => 'block',
							'caption' => '',
							'before' => '<span class="post_meta_item post_share">',
							'after' => '</span>'
						));
				}
                    ?></div><?php }?></div></div><?php

			do_action('militarology_action_after_post_meta'); 
		}
		?>
	</div><!-- .entry-content -->
	

	<?php
	do_action('militarology_action_after_post_content'); 

	// Author bio.
	if ( militarology_get_theme_option('show_author_info')==1 && is_single() && !is_attachment() && get_the_author_meta( 'description' ) ) {
		do_action('militarology_action_before_post_author'); 
		get_template_part( 'templates/author-bio' );
		do_action('militarology_action_after_post_author'); 
	}

	do_action('militarology_action_after_post_data'); 
	?>
</article>
