<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$militarology_post_format = get_post_format();
$militarology_post_format = empty($militarology_post_format) ? 'standard' : str_replace('post-format-', '', $militarology_post_format);
$militarology_animation = militarology_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($militarology_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($militarology_post_format) ); ?>
	<?php echo (!militarology_is_off($militarology_animation) ? ' data-animation="'.esc_attr(militarology_get_animation_classes($militarology_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	militarology_show_post_featured(array(
		'thumb_size' => militarology_get_thumb_size($militarology_columns==1 ? 'big' : ($militarology_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($militarology_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(), 'sticky', $militarology_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>