<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_blog_style = explode('_', militarology_get_theme_option('blog_style'));
$militarology_columns = empty($militarology_blog_style[1]) ? 2 : max(2, $militarology_blog_style[1]);
$militarology_post_format = get_post_format();
$militarology_post_format = empty($militarology_post_format) ? 'standard' : str_replace('post-format-', '', $militarology_post_format);
$militarology_animation = militarology_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($militarology_columns).' post_format_'.esc_attr($militarology_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!militarology_is_off($militarology_animation) ? ' data-animation="'.esc_attr(militarology_get_animation_classes($militarology_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$militarology_image_hover = militarology_get_theme_option('image_hover');
	// Featured image
	militarology_show_post_featured(array(
		'thumb_size' => militarology_get_thumb_size(strpos(militarology_get_theme_option('body_style'), 'full')!==false || $militarology_columns < 3 
								? 'masonry-big' 
								: 'masonry'),
		'show_no_image' => true,
		'class' => $militarology_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $militarology_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>