<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_blog_style = explode('_', militarology_get_theme_option('blog_style'));
$militarology_columns = empty($militarology_blog_style[1]) ? 2 : max(2, $militarology_blog_style[1]);
$militarology_post_format = get_post_format();
$militarology_post_format = empty($militarology_post_format) ? 'standard' : str_replace('post-format-', '', $militarology_post_format);
$militarology_animation = militarology_get_theme_option('blog_animation');
$militarology_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($militarology_columns).' post_format_'.esc_attr($militarology_post_format) ); ?>
	<?php echo (!militarology_is_off($militarology_animation) ? ' data-animation="'.esc_attr(militarology_get_animation_classes($militarology_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($militarology_image[1]) && !empty($militarology_image[2])) echo intval($militarology_image[1]) .'x' . intval($militarology_image[2]); ?>"
	data-src="<?php if (!empty($militarology_image[0])) echo esc_url($militarology_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$militarology_image_hover = 'icon';
	if (in_array($militarology_image_hover, array('icons', 'zoom'))) $militarology_image_hover = 'dots';
	$militarology_components = militarology_is_inherit(militarology_get_theme_option_from_meta('meta_parts')) 
								? 'categories,date,counters,share'
								: militarology_array_get_keys_by_value(militarology_get_theme_option('meta_parts'));
	$militarology_counters = militarology_is_inherit(militarology_get_theme_option_from_meta('counters')) 
								? 'comments'
								: militarology_array_get_keys_by_value(militarology_get_theme_option('counters'));
	militarology_show_post_featured(array(
		'hover' => $militarology_image_hover,
		'thumb_size' => militarology_get_thumb_size( strpos(militarology_get_theme_option('body_style'), 'full')!==false || $militarology_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($militarology_components)
										? militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
											'components' => $militarology_components,
											'counters' => $militarology_counters,
											'seo' => false,
											'echo' => false
											), $militarology_blog_style[0], $militarology_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'militarology') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>