<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_post_format = get_post_format();
$militarology_post_format = empty($militarology_post_format) ? 'standard' : str_replace('post-format-', '', $militarology_post_format);
$militarology_animation = militarology_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($militarology_post_format) ); ?>
	<?php echo (!militarology_is_off($militarology_animation) ? ' data-animation="'.esc_attr(militarology_get_animation_classes($militarology_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	militarology_show_post_featured(array( 'thumb_size' => militarology_get_thumb_size( strpos(militarology_get_theme_option('body_style'), 'full')!==false ? 'full' : 'huge' ) ));

	?><div class="post-body"><?php

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('militarology_action_before_post_title');

            // Post meta

                militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
                        'components' => 'date',
                        'counters' => '',
                        'seo' => false
                    ), 'excerpt', 1)
                );

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('militarology_action_before_post_meta');

			?>
		</div><!-- .post_header --><?php
	}

	// Post content
	?><div class="post_content entry-content"><?php
		if (militarology_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'militarology' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'militarology' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$militarology_show_learn_more = true;

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($militarology_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($militarology_post_format == 'quote') {
					if (($quote = militarology_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						militarology_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><div class="post-bottom"><div class="bls"><?php

            // Post meta
            $militarology_components = 'categories';


            if (!empty($militarology_components))
                militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
                        'components' => $militarology_components,
                        'counters' => '',
                        'seo' => false
                    ), 'excerpt', 1)
                );

                $militarology_components = 'counters';

                $militarology_counters = militarology_is_inherit(militarology_get_theme_option_from_meta('counters'))
                    ? 'views,comments'
                    : militarology_array_get_keys_by_value(militarology_get_theme_option('counters'));

                if (!empty($militarology_components))
                    militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
                            'components' => $militarology_components,
                            'counters' => $militarology_counters,
                            'seo' => false
                        ), 'excerpt', 1)
                    );


            ?></div><div class="brs"><?php
			// More button
			if ( $militarology_show_learn_more ) {
				?><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'militarology'); ?></a><?php
			}
			?></div></div><?php

		}
            ?></div></div><!-- .entry-content -->
</article>