<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_blog_style = explode('_', militarology_get_theme_option('blog_style'));
$militarology_columns = empty($militarology_blog_style[1]) ? 2 : max(2, $militarology_blog_style[1]);
$militarology_expanded = !militarology_sidebar_present() && militarology_is_on(militarology_get_theme_option('expand_content'));
$militarology_post_format = get_post_format();
$militarology_post_format = empty($militarology_post_format) ? 'standard' : str_replace('post-format-', '', $militarology_post_format);
$militarology_animation = militarology_get_theme_option('blog_animation');
$militarology_components = militarology_is_inherit(militarology_get_theme_option_from_meta('meta_parts')) 
							? 'date'
							: militarology_array_get_keys_by_value(militarology_get_theme_option('meta_parts'));
$militarology_counters = militarology_is_inherit(militarology_get_theme_option_from_meta('counters')) 
							? 'comments'
							: militarology_array_get_keys_by_value(militarology_get_theme_option('counters'));

?><div class="<?php militarology_show_layout($militarology_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'); ?>-1_<?php echo esc_attr($militarology_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($militarology_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($militarology_columns)
					. ' post_layout_'.esc_attr($militarology_blog_style[0]) 
					. ' post_layout_'.esc_attr($militarology_blog_style[0]).'_'.esc_attr($militarology_columns)
					); ?>
	<?php echo (!militarology_is_off($militarology_animation) ? ' data-animation="'.esc_attr(militarology_get_animation_classes($militarology_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	militarology_show_post_featured( array( 'thumb_size' => militarology_get_thumb_size($militarology_blog_style[0] == 'classic'
													? (strpos(militarology_get_theme_option('body_style'), 'full')!==false 
															? ( $militarology_columns > 2 ? 'big' : 'huge' )
															: (	$militarology_columns > 2
																? ($militarology_expanded ? 'med' : 'small')
																: ($militarology_expanded ? 'big' : 'med')
																)
														)
													: (strpos(militarology_get_theme_option('body_style'), 'full')!==false 
															? ( $militarology_columns > 2 ? 'masonry-big' : 'full' )
															: (	$militarology_columns <= 2 && $militarology_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($militarology_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('militarology_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('militarology_action_before_post_meta'); 

			// Post meta
			if (!empty($militarology_components))
				militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
					'components' => $militarology_components,
					'counters' => $militarology_counters,
					'seo' => false
					), $militarology_blog_style[0], $militarology_columns)
				);

			do_action('militarology_action_after_post_meta'); 
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$militarology_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($militarology_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($militarology_post_format == 'quote') {
				if (($quote = militarology_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					militarology_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($militarology_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($militarology_components))
				militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
					'components' => $militarology_components,
					'counters' => $militarology_counters
					), $militarology_blog_style[0], $militarology_columns)
				);
		}
		// More button
		if ( $militarology_show_learn_more ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'militarology'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>