<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MILITAROLOGY
 * @since MILITAROLOGY 1.0
 */

$militarology_blog_style = explode('_', militarology_get_theme_option('blog_style'));
$militarology_columns = empty($militarology_blog_style[1]) ? 1 : max(1, $militarology_blog_style[1]);
$militarology_expanded = !militarology_sidebar_present() && militarology_is_on(militarology_get_theme_option('expand_content'));
$militarology_post_format = get_post_format();
$militarology_post_format = empty($militarology_post_format) ? 'standard' : str_replace('post-format-', '', $militarology_post_format);
$militarology_animation = militarology_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($militarology_columns).' post_format_'.esc_attr($militarology_post_format) ); ?>
	<?php echo (!militarology_is_off($militarology_animation) ? ' data-animation="'.esc_attr(militarology_get_animation_classes($militarology_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($militarology_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	militarology_show_post_featured( array(
											'class' => $militarology_columns == 1 ? 'militarology-full-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => militarology_get_thumb_size(
																	strpos(militarology_get_theme_option('body_style'), 'full')!==false
																		? ( $militarology_columns > 1 ? 'huge' : 'original' )
																		: (	$militarology_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('militarology_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('militarology_action_before_post_meta'); 

			// Post meta
			$militarology_components = militarology_is_inherit(militarology_get_theme_option_from_meta('meta_parts')) 
										? ($militarology_columns < 2 ? 'categories,' : '').'date'.($militarology_columns < 2 ? ',counters' : '')
										: militarology_array_get_keys_by_value(militarology_get_theme_option('meta_parts'));
			$militarology_counters = militarology_is_inherit(militarology_get_theme_option_from_meta('counters')) 
										? 'comments'
										: militarology_array_get_keys_by_value(militarology_get_theme_option('counters'));
			$militarology_post_meta = empty($militarology_components) 
										? '' 
										: militarology_show_post_meta(apply_filters('militarology_filter_post_meta_args', array(
												'components' => $militarology_components,
												'counters' => $militarology_counters,
												'seo' => false,
												'echo' => false
												), $militarology_blog_style[0], $militarology_columns)
											);
			militarology_show_layout($militarology_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$militarology_show_learn_more = !in_array($militarology_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($militarology_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($militarology_post_format == 'quote') {
					if (($quote = militarology_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						militarology_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($militarology_post_format, array('link', 'aside', 'status', 'quote'))) {
				militarology_show_layout($militarology_post_meta);
			}
			// More button
			if ( $militarology_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'militarology'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>